#ifndef USBMOUSE_H
#define USBMOUSE_H
#include "USBHID.h"
#define REPORT_ID_MOUSE   2

#define X_MIN_REL    (-127)     /*!< The maximum value that we can move to the left on the x-axis */
#define Y_MIN_REL    (-127)     /*!< The maximum value that we can move up on the y-axis */
#define X_MAX_REL    (127)      /*!< The maximum value that we can move to the right on the x-axis */
#define Y_MAX_REL    (127)      /*!< The maximum value that we can move down on the y-axis */

enum MOUSE_BUTTON
{
    MOUSE_LEFT = 1,
    MOUSE_RIGHT = 2,
    MOUSE_MIDDLE = 4,
};
enum MOUSE_TYPE
{
    REL_MOUSE,
    ABS_MOUSE
};

class USBMouse: public USBHID
{
    public:
        USBMouse(MOUSE_TYPE mouse_type = REL_MOUSE, uint16_t vendor_id = 0x1234, uint16_t product_id = 0x0001, uint16_t product_release = 0x0001):
            USBHID(0, 0, vendor_id, product_id, product_release, false)
            {
                button = 0;
                this->mouse_type = mouse_type;
                connect();
            };
        bool update(int16_t x, int16_t y, uint8_t buttons, int8_t z);
        bool move(int16_t x, int16_t y);
        bool press(uint8_t button);
        bool release(uint8_t button);
        bool doubleClick();
        bool click(uint8_t button);
        bool scroll(int8_t z);
        virtual uint8_t * reportDesc();

    protected:
         virtual uint8_t * configurationDesc();

    private:
        MOUSE_TYPE mouse_type;
        uint8_t button;
        bool mouseSend(int8_t x, int8_t y, uint8_t buttons, int8_t z);
};

#endif
