

#ifndef USB_HID_H
#define USB_HID_H
#include "USBEndpoints.h"
#include "USBDescriptor.h"
#include "USBDevice_Types.h"

#include "USBHID_Types.h"
#include "USBDevice.h"

class USBHID: public USBDevice {
public:

    USBHID(uint8_t output_report_length = 64, uint8_t input_report_length = 64, uint16_t vendor_id = 0x1234, uint16_t product_id = 0x0006, uint16_t product_release = 0x0001, bool connect = true);

    bool send(HID_REPORT *report);
    bool sendNB(HID_REPORT *report);
    bool read(HID_REPORT * report);
    bool readNB(HID_REPORT * report);

protected:
    uint16_t reportLength;
    virtual uint8_t * reportDesc();
    virtual uint16_t reportDescLength();
    virtual uint8_t * stringIproductDesc();
    virtual uint8_t * stringIinterfaceDesc();
    virtual uint8_t * configurationDesc();
    virtual void HID_callbackSetReport(HID_REPORT *report){};
    virtual bool USBCallback_request();
    virtual bool USBCallback_setConfiguration(uint8_t configuration);

private:
    HID_REPORT outputReport;
    uint8_t output_length;
    uint8_t input_length;
};

#endif
