#include "mbed.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "HTTPClient.h"
Serial pc(USBTX, USBRX);
// networking stuff
EthernetNetIf eth;
NTPClient ntp;
HTTPClient http;
 
char* thingSpeakUrl = "https://api.thingspeak.com/apps/thingtweet/1/statuses/update";
char* thingSpeakKey = "Z0EQH6OQ8HLNNL6G";
 
char urlBuffer[256];
char timeBuffer[64];
 
// pin defs
AnalogIn temp(p20);
 
int main() {
 
    pc.printf("Start\r\n");
 
    pc.printf("Setting up Ethernet...\r\n");
   EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        pc.printf("Error %d in ethernet setup.\r\n", ethErr);
        return -1;
    }
    pc.printf("Ethernet setup OK\r\n");
   
    while(1)
    {
        float temperature = temp.read();
        temperature=temperature*150;
       
        // for debug
        pc.printf("Time: %s, Temperature: %f\r\n", timeBuffer, temperature);
       
        // format url here
        urlBuffer[0] = 0;
        sprintf(urlBuffer, "%s?api_key=%s&status= %s %f", thingSpeakUrl, thingSpeakKey, "Temperature",temperature);
        pc.printf("Request to %s\r\n", urlBuffer);
       
        HTTPText resp;
        HTTPResult res = http.get(urlBuffer, &resp);
        if (res == HTTP_OK)
        {
            pc.printf("Result :\"%s\"\r\n", resp.gets());
        }
        else
        {
            pc.printf("Error %d\r\n", res);
        }
       
        wait(16); // limited by ThingSpeak's API
   }
 }  