#include "mbed.h"

class Accelerometer
{
public:
  Accelerometer(PinName sda, PinName scl, int address); // Accelerometer pin definition
  ~Accelerometer();          // Accelerometer Destructor

  float Acc_X();      // Get X axis Acceleration

  float Acc_Y();      // Get Y axis Acceleration

  float Acc_Z();      // Get Z axis Acceleration
  
  
private:
  I2C i2c;
  int addr;
  void readRegs(int addr, uint8_t * data, int len);
  void writeRegs(uint8_t * data, int len);
  int16_t getAccAxis(uint8_t addr);
};

 





