#include "mbed.h"
#include "USBMouse.h"
#include "Accelerometer.h"
#include "TouchSensor.h"
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)
 
USBMouse mouse;
Accelerometer acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
TouchSensor tsi;
 
typedef enum {NONE = 0, LEFT, RIGHT} Click;
 
int main() {
    int16_t x = 0, y = 0;
    float t;
    Click in_click = NONE;
 
    while (1) {
        t = acc.Acc_X();
        t *= 10/1.5;
        y = (int16_t) t;
        
        t = acc.Acc_Y();
        t *= 10/1.5;
        x = - (int16_t) t;
        
        t = tsi.readPercentage();
        
        if (in_click == NONE) {
            if (t > 0.6) {
                mouse.press(MOUSE_LEFT);
                in_click = LEFT;
            } else if (t > 0.1) {
                mouse.press(MOUSE_RIGHT);
                in_click = RIGHT;
            }
        } else if (in_click == LEFT) {
            if (t <= 0.6) {
                mouse.release(MOUSE_LEFT);
                in_click = NONE;
            }
        } else {
            if (t > 0.6 || t <= 0.1) {
                mouse.release(MOUSE_RIGHT);
                in_click = NONE;
            }
        }
        
        mouse.move(x, y);
        wait(0.001);
    }
}