#include "mbed.h"
#include "MRF24J40.h"
#include <string>


// RF tranceiver to link with handheld.
MRF24J40 mrf(p11, p12, p13, p14, p21);

// LEDs you can treat these as variables (led2 = 1 will turn led2 on!)
DigitalOut led1(LED1);
DigitalOut led2(LED2);
// Timer
Timer timer;

// Serial port for showing RX data.
Serial pc(USBTX, USBRX);

// Used for sending and receiving
char txBuffer[128];
char rxBuffer[128];
int rxLen;

//***************** Do not change these methods (please) *****************//

/**
* Receive data from the MRF24J40.
*
* @param data A pointer to a char array to hold the data
* @param maxLength The max amount of data to read.
*/
int rf_receive(char *data, uint8_t maxLength)
{
    uint8_t len = mrf.Receive((uint8_t *)data, maxLength);
    uint8_t header[8]= {1, 8, 0, 0xA1, 0xB2, 0xC3, 0xD4, 0x00};

    if(len > 10) {
        //Remove the header and footer of the message
        for(uint8_t i = 0; i < len-2; i++) {
            if(i<8) {
                //Make sure our header is valid first
                if(data[i] != header[i])
                    return 0;
            } else {
                data[i-8] = data[i];
            }
        }

        //pc.printf("Received: %s length:%d\r\n", data, ((int)len)-10);
    }
    return ((int)len)-10;
}

/**
* Send data to another MRF24J40.
*
* @param data The string to send
* @param maxLength The length of the data to send.
*                  If you are sending a null-terminated string you can pass strlen(data)+1
*/
void rf_send(char *data, uint8_t len)
{
    //We need to prepend the message with a valid ZigBee header
    uint8_t header[8]= {1, 8, 0, 0xA1, 0xB2, 0xC3, 0xD4, 0x00};
    uint8_t *send_buf = (uint8_t *) malloc( sizeof(uint8_t) * (len+8) );

    for(uint8_t i = 0; i < len+8; i++) {
        //prepend the 8-byte header
        send_buf[i] = (i<8) ? header[i] : data[i-8];
    }
    //pc.printf("Sent: %s\r\n", send_buf+8);

    mrf.Send(send_buf, len+8);
    free(send_buf);
}


//***************** You can start coding here *****************//
int main (void)
{

    
while(1){
    
    
        printf("Do you want to play? [y/n] \n");
        char start = pc.getc();
        
        if(start == 'n'){
            printf("Game Over\n");
            exit(0); //exit is OK
        }
        
        else if(start == 'y'){
        
        printf("Start Whacking ... \n");
        //Set the Number of slaves
        int slaves = 2;
        
        //Channels of the nodes
        //channel1 = 15; //channel of the first node
        //channel2 = 14; //channel of the first node
        uint8_t channel;
        
        //Set the Count to 10
        int count,n = 0;
        int dont_set_channel = 0;
        float begin = 0;
        float end   = 0;
        float diff  = 0;
        float tdiff = 0;
        
        //Start the timer
        timer.start();
        
        //Set the yes and no arrays
        char yes[] = "y";
        char no[]  = "n";
    
        while(count < 10) {
            
            //Send message to random node
            
            //Calculate random number
            //srand(time(0));
            channel = (rand()%(slaves)) + 14;  
            //channel = 15;
            
            //Check for channel of the mole if a light was missed 
            while(dont_set_channel == channel){
                channel = (rand()%(slaves)) + 14; //set to minimum channel     
            }
            
            //dont_set_channel= 0;
                       
            //Set the Channel to the random node selected
            mrf.SetChannel(channel);
            
            //Send message to the random slave and start timer
            char num = n;
            char* numptr;
            numptr = &num;
            strcpy(txBuffer, numptr);
            rf_send(txBuffer, strlen(txBuffer) + 1);
            //Switch on the Led when sending data
            led2 = 1;
            printf("Sending signal to mole %u \n", channel - 14);
            begin = timer.read_ms();
            
            //Wait for reply from the slave 
            
            while(1){
                
                rxLen = rf_receive(rxBuffer, 128);    
                
                if(rxLen > 0) {
                    
                    //Calculate time difference
                    end = timer.read_ms();
                    diff = end - begin;
                    tdiff += (diff / 1000);
                    
                    //Switch off Led to indicate received data
                    led2 = 0; 
                    
                    //Check if mole was pressed or not
                    pc.printf("Received: %s\r\n", rxBuffer);
                    
                    //If it was pressed - increment the count
                    if(strcmp (yes,rxBuffer) == 0){
                        pc.printf("pressed\n");
                        count++;
                        n++;
                        //strcpy(txBuffer, "d"); //send d to decrement the time on slaves end
                        dont_set_channel = 0;
                    }
                    //If it was not pressed - dont alter the count
                    else if(strcmp (no,rxBuffer) == 0){
                        pc.printf("Not pressed\n");
                        //strcpy(txBuffer, "s");
                        tdiff += 3; // Penalty of 3 seconds
                        dont_set_channel = channel; // if there was no press do not send on light on this channel again
                       
                    }
                        
                    break;
                    
                }//end of "if" receive 
                
            }//end of inner while 
            
        }//end of while count
        
        printf("Your did it in %f seconds\n",tdiff);
    
    }//end of else if start 
  }//end of while 1
}// end of main
