#include <string.h>
#include "mbed.h"
#include "easy-connect.h"
#include "TCPSocket.h"
#include "DHT.h"

DHT sensor(A0,DHT22);

#define SERVER_IP "192.168.0.5"
#define SERVER_PORT 50000

Serial pc(USBTX, USBRX);

char rec_buf[20];

int main(){
    int error = 0;
    pc.baud(115200);

    pc.printf("\r\nConnecting...\r\n");
    NetworkInterface *network = easy_connect(true);
    while(!network){
        pc.printf("Error: Cannot connect to the network\r\n");
        wait(1);
        network = easy_connect(true);
    }
    
    pc.printf("Success\r\n\r\n");
    pc.printf("MAC: %s\r\n", network->get_mac_address());
    pc.printf("IP: %s\r\n", network->get_ip_address());
    pc.printf("Netmask: %s\r\n", network->get_netmask());
    pc.printf("Gateway: %s\r\n", network->get_gateway());
    pc.printf("RSSI: %d\r\n\r\n", wifi.get_rssi());

    pc.printf("\r\nDone\r\n");

    TCPSocket socket;

    socket.open(network);
    socket.connect(SERVER_IP, SERVER_PORT);

    int c = 0, h = 0;
    int send_cnt, rec_cnt;
    while(1){
        pc.printf("Sending request to %s : %d ...\r\n", SERVER_IP, SERVER_PORT);
        char rec_buf[64]={};
        rec_cnt = socket.recv(rec_buf, sizeof rec_buf);
        pc.printf("%s\r\n", rec_buf);
        if(!strcmp(rec_buf, "GET /DHT22\r\n")){
            char send_buf[64]={};
            send_cnt = socket.send("OK\r\n", sizeof("OK\r\n"));
            error = sensor.readData();
            if (error == 0) {
                c   = sensor.ReadTemperature(CELCIUS);
                h   = sensor.ReadHumidity();
            }
            else {
                printf("Error: %d\r\n", error);
            }
            sprintf(send_buf, "{ \"temp\": \"%d\", \"humid\": \"%d\"}\r\n", c, h);
            send_cnt = socket.send(send_buf, sizeof(send_buf));
            pc.printf(send_buf);
        }
        else{
            pc.printf("Unknown request\r\n");
            send_cnt = socket.send("Unknown request\r\n", sizeof("Unknown request\r\n"));
        }
    }
}

