#include "mbed.h"

#if defined(TARGET_LPC1114)
Serial sr(dp16, dp15);

PwmOut BMotorCCW(dp18);
PwmOut BMotorCW(dp24);
DigitalOut BMotorCCWSW(dp9);
DigitalOut BMotorCWSW(dp10);
#elif defined(TARGET_STM32F401RE)
Serial sr(D1, D0);

PwmOut BMotorCCW(D6);
PwmOut BMotorCW(D5);
DigitalOut BMotorCCWSW(D4);
DigitalOut BMotorCWSW(D3);
#endif

int main() {

    sr.baud(19200);

    wait(5);

    while(1) {
        for (int i = 38; i < 40; i++) {
#if defined(TARGET_LPC1114)
            BMotorCCW = (float)i / 100.0;
#elif defined(TARGET_STM32F401RE)
            BMotorCCW = (double)i / 100.0;
#endif
            BMotorCW = 0.0;
            BMotorCCWSW = 1;
            BMotorCWSW = 0;
            sr.printf("BCCW = %d/100 BCW = %d/100 BCCWSW = %d BCWSW = %d\r\n", i, i, 1, 0);
            wait(3);
            BMotorCCW = 0.0;
            BMotorCW = 0.0;
            BMotorCCWSW = 0;
            BMotorCWSW = 0;
            sr.printf("BCCW = %d/100 BCW = %d/100 BCCWSW = %d BCWSW = %d\r\n", i, i, 0, 0);
            wait(1);
            BMotorCCW = 0.0;
#if defined(TARGET_LPC1114)
            BMotorCW = (float)i / 100.0;
#elif defined(TARGET_STM32F401RE)
            BMotorCW = (double)i / 100.0;
#endif
            BMotorCCWSW = 0;
            BMotorCWSW = 1;
            sr.printf("BCCW = %d/100 BCW = %d/100 BCCWSW = %d BCWSW = %d\r\n", i, i, 0, 1);
            wait(3);
            BMotorCCW = 0.0;
            BMotorCW = 0.0;
            BMotorCCWSW = 0;
            BMotorCWSW = 0;
            sr.printf("BCCW = %d/100 BCW = %d/100 BCCWSW = %d BCWSW = %d\r\n", i, i, 0, 0);
            wait(1);
        }
        for (int i = 40; i <= 100; i += 10) {
#if defined(TARGET_LPC1114)
            BMotorCCW = (float)i / 100.0;
#elif defined(TARGET_STM32F401RE)
            BMotorCCW = (double)i / 100.0;
#endif
            BMotorCW = 0.0;
            BMotorCCWSW = 1;
            BMotorCWSW = 0;
            sr.printf("BCCW = %d/100 BCW = %d/100 BCCWSW = %d BCWSW = %d\r\n", i, i, 1, 0);
            wait(3);
            BMotorCCW = 0.0;
            BMotorCW = 0.0;
            BMotorCCWSW = 0;
            BMotorCWSW = 0;
            sr.printf("BCCW = %d/100 BCW = %d/100 BCCWSW = %d BCWSW = %d\r\n", i, i, 0, 0);
            wait(2);
            BMotorCCW = 0.0;
#if defined(TARGET_LPC1114)
            BMotorCW = (float)i / 100.0;
#elif defined(TARGET_STM32F401RE)
            BMotorCW = (double)i / 100.0;
#endif
            BMotorCCWSW = 0;
            BMotorCWSW = 1;
            sr.printf("BCCW = %d/100 BCW = %d/100 BCCWSW = %d BCWSW = %d\r\n", i, i, 0, 1);
            wait(3);
            BMotorCCW = 0.0;
            BMotorCW = 0.0;
            BMotorCCWSW = 0;
            BMotorCWSW = 0;
            sr.printf("BCCW = %d/100 BCW = %d/100 BCCWSW = %d BCWSW = %d\r\n", i, i, 0, 0);
            wait(2);
        }
    }
}
