#ifndef RPCOBJECTMANAGER
#define RPCOBJECTMANAGER

#include <list>

class RPCObjectManager
{
    public :
        
        static RPCObjectManager& instance();
        
        void store_object(char *obj_name);
        void remove_object(char *obj_name);
        bool lookup_object(char *obj_name);
        
        std::list<char*>::iterator begin();
        std::list<char*>::iterator end();

        bool is_empty();
        
    private :
    
        RPCObjectManager();
        ~RPCObjectManager();
        
        std::list<char*> objects;
};
#endif

