#include "RPCCommand.h"
#include "mbed.h"
#include "RPCType.h"


RPCCommand::RPCCommand():
cmd(),
obj_name(NULL),
func_name(NULL)
{

}

bool RPCCommand::decode(char *buffer)
{
    if(buffer == NULL)
        return false;
    if(buffer[0] != '/')
        return false;
    
    ++buffer;
    char *tmp = strchr(buffer ,'/');

    if(tmp == NULL)
        return false;
    if(tmp == buffer)
        return false;
    
    tmp[0] = '\0';
    obj_name = buffer;
    
    buffer = tmp+1;
    
    if(buffer[0] == '\0' || buffer[0] == '?')
        return false;
    
    func_name = buffer;
    
    tmp = strchr(buffer, '?');
    if(tmp != NULL)
    {
        if(tmp[1] == '\0')
            return false;
        tmp[0] = '\0';
    }
    
    cmd[0] = '\0';
    strcat(cmd, "/");
    strcat(cmd, obj_name);
    strcat(cmd, "/");
    strcat(cmd, func_name);

    if(tmp == NULL)
        return true;
    
    buffer = tmp+1;
    do
    {
        tmp = strchr(buffer, '&');
        
        if(tmp != NULL)
        {
            if(tmp[1] == '\0' || buffer == tmp)
                return false;
            tmp[0] = '\0';
        }

        char *sep = strchr(buffer, '=');
        if(sep == NULL)
            return false;
        if(sep == buffer)
            return false;
        if(sep[1] == '\0' || sep[1] == '&')
            return false;
        
        strcat(cmd, " ");
        strcat(cmd, sep+1);
        
        if(tmp != NULL)
            buffer = tmp+1;
        else
            buffer = NULL;
    }while(buffer);
    
    return true;
}



char* RPCCommand::get_cmd() const
{
    return (char*)cmd;
}

RPC_COMMAND_TYPE RPCCommand::get_type() const
{
    if(!strcmp(func_name, "new") && RPCType::instance().is_supported_type(obj_name))
        return CREATE;
    
    RPC* r = RPC::lookup(obj_name);
    if(r == NULL)
        return INVALID;
    
    if(!strcmp(func_name, "delete"))
        return DELETE;
        
    const struct rpc_method *methods = r->get_rpc_methods();
    int i = 0;
    while(methods[i].name != NULL)
    {
        if(!strcmp(func_name, methods[i].name))
        {
            return FUNCTION_CALL;
        }
        ++i;
    }
    
    return INVALID;
}

char* RPCCommand::get_obj_name() const
{
    return obj_name;
}

char* RPCCommand::get_func_name() const
{
    return func_name;
}

