#include "ITG3205.h"

Gyroscope::Gyroscope(){
    // variable initialization
    offset.x = 0;
    offset.y = 0;
    offset.z = 0;
    
    // Gyroscope IMU address
    ITG3205_addr = 0x68 << 1;
    
    // Register address
    WHO_AM_I = 0x00;
    DLPF_FS = 0x16;
    PWR_MGM = 0x3E;
    SMPLRT_DIV = 0x15;
    
    // device register content
    chip_id = 0x68;
    
    // Register access address
    GYRO_XOUT_H = 0x1D;  
    
    if (GyroInit()){
        // if gyroscope isn't detected, code halted
        //return 1;    
        pc.printf("Gyroscope undetected \n");  
    } else {
        pc.printf("Gyroscope read successfully \n");    
    }     
    GyroCalib();   
}

int Gyroscope::GyroInit(){
    char reg_data[2];

   // ITG3205 Initialization
   // Verifying ITG3205
    reg_data[0] = WHO_AM_I;
    IMU.write(ITG3205_addr,reg_data,1); 
    IMU.read(ITG3205_addr,reg_data,1);  
       
    if (reg_data[0] != chip_id) {
        pc.printf("invalid chip gyroscope id %x\n",reg_data[0]);
        return 1;
    }     
    
    // Select PLL with X Gyro reference as ITG3025 clock source
    reg_data[0] = PWR_MGM;
    reg_data[1] = 0x01;
    IMU.write(ITG3205_addr,reg_data,2);

    // Select range +/- 2000 dgrs/sec, Lowpass Filter Bandwidth 188 Hz, and Internal Sample Rate 1kHz   
    reg_data[0] = DLPF_FS;
    reg_data[1] = 0x19;
    IMU.write(ITG3205_addr,reg_data,2);
    
    // Select Sample Rate Divider 10 so the output sample 100 Hz
    reg_data[0] = SMPLRT_DIV;
    reg_data[1] = 0x09;
    IMU.write(ITG3205_addr,reg_data,2);   
    
    return 0;    
}

void Gyroscope::GyroCalib(){
    int i;
    int x = 0;
    int y = 0;
    int z = 0;
    
    for (i=0;i<1000;i++){
        GyroRawRead();
        x = (raw.x + x)/2;     
        y = (raw.y + y)/2;
        z = (raw.z + z)/2;           
    }
    
    offset.x = x;
    offset.y = y;
    offset.z = z;      
}

void Gyroscope::GyroRawRead(){
    char data[6];  
    
    data[0] = GYRO_XOUT_H;
    IMU.write(ITG3205_addr,data,1);
    if(IMU.read(ITG3205_addr,data,6) == 0){
        raw.x = (short)((data[0] << 8) | data[1]);
        raw.y = (short)((data[2] << 8) | data[3]);
        raw.z = (short)((data[4] << 8) | data[5]);
    } else {
        pc.printf("No bytes received in ITG3205!\n");     
    }     
}

void Gyroscope::GyroRead(){
    float dz;   
    
    GyroRawRead();
    
    XAngularRate = (raw.x - offset.x)/14.375;//(32768.0/2000.0);
    YAngularRate = (raw.y - offset.y)/14.375;//(32768.0/2000.0);
    dz = (raw.z - offset.z)/14.375;//(32768.0/2000.0);              
}

float Gyroscope::getXAngularRate(){
    return XAngularRate;
}

float Gyroscope::getYAngularRate(){
    return YAngularRate;
}
