// GPS synchronised data logger
// Uses the $GPRMC string for time and date
// synchronisation
// Code derived from Arduino GPS examples
// and the MBED GPS library
// http://www.arduino.cc/
// Thanks Lady Ada and others!

#include "mbed.h"
// Commands for Globalsat EM-406A GPS
// to turn on or off data strings
#define RMC_ON   "$PSRF103,4,0,1,1*21\r\n"
#define RMC_OFF  "$PSRF103,4,0,0,1*20\r\n"
#define GGA_ON   "$PSRF103,0,0,1,1*25\r\n"
#define GGA_OFF  "$PSRF103,0,0,0,1*24\r\n"
#define GSA_ON   "$PSRF103,2,0,1,1*27\r\n"
#define GSA_OFF  "$PSRF103,2,0,0,1*26\r\n"
#define GSV_ON   "$PSRF103,3,0,1,1*26\r\n"
#define GSV_OFF  "$PSRF103,3,0,0,1*27\r\n"
#define WAAS_ON  "$PSRF151,1*3F\r\n"
#define WAAS_OFF "$PSRF151,0*3E\r\n"

// Set up serial ports and LEDs
// MBED USB port used for console debug messages
// EM-406A GPS on Pin9 and Pin10
Serial pc(USBTX, USBRX); // tx, rx - Default 9600 baud
Serial gps(p9, p10);     // tx, rx - 4800 baud required
DigitalOut led1(LED1);   // Seconds LED
DigitalOut led4(LED4);   // Data sent LED

//char buffidx;
char msg[256];           // GPS data buffer
char status;             // GPS status 'V' = Not locked; 'A' = Locked
char *parseptr;          // Pointer for parsing GPS message
char time_buff[7] = "000000";
char date_buff[7] = "000000";
char sens_buff[7] = "123456";

// Switch off all but $GPRMC string
void setgps() {
    gps.printf(RMC_ON);
    gps.printf(GGA_OFF);
    gps.printf(GSA_OFF);
    gps.printf(GSV_OFF);
    gps.printf(WAAS_OFF);
    return;
}
// Get line of data from GPS
void getline() {
    while (gps.getc() != '$'); // Wait for start of line
    for (int i=0; i<256; i++) {
        msg[i] = gps.getc();
// pc.putc(msg[i]);
        if (msg[i] == '\r') {
            msg[i] = 0;
            return;
        }
    }
}
// Flash LED 1
void flashled1(void) {
    led1 = 1;
    wait(0.05);
    led1 = 0;
    wait(0.05);
}
// Flash LED4
void flashled4(void) {
    led4 = 1;
    wait(0.1);
    led4 = 0;
    wait(0.1);
}
void read_sensor() {
// Insert code here to read sensor
// and store data in sens_buff[]
}
void send_data() {
// Insert code to send data
    pc.printf(sens_buff);
    pc.printf("\r\n");
}

int main(void) {
    gps.baud(4800);         // NB GPS baud rate 4800
    pc.printf("\n\rGPS Logger Running!...\n\r");
    setgps();
    while (1) {
        getline();
        if (strncmp(msg, "GPRMC",5) == 0) {
            // Put the time into the time array
            parseptr = msg+6;
            for (int i = 0; i < 6; i++) {
                time_buff[i] = parseptr[i];
            }
            // Skip through commas in the data string
            // Firstly to get to the status flag and
            // then to pick up the date
            parseptr = strchr(parseptr, ',')+1;
            status = parseptr[0];
            parseptr = strchr(parseptr, ',')+1;
            parseptr = strchr(parseptr, ',')+1;
            parseptr = strchr(parseptr, ',')+1;
            parseptr = strchr(parseptr, ',')+1;
            parseptr = strchr(parseptr, ',')+1;
            parseptr = strchr(parseptr, ',')+1;
            parseptr = strchr(parseptr, ',')+1;
            // Put the date into the date array
            for (int i = 0; i < 6; i++) {
                date_buff[i] = parseptr[i];
            }
            // Every second output time, date and lock status
            // to the console and flash LED1
            pc.printf(time_buff);
            pc.printf(",");
            pc.printf(date_buff);
            pc.printf(",");
            pc.putc(status);
            pc.printf("\r\n");
            flashled1();
            // Take a sensor reading every minute
            // ie is the time hh:mm:00
            if (time_buff[4] == 0x30 && time_buff[5] == 0x30) {
                pc.printf("\r\nSensor Reading!\r\n");
                read_sensor();
                pc.printf("Sending: ");
                send_data();
                pc.printf("\r\n");
                flashled4();

            }
        }
    }
}

