

#include "mbed.h"
#include "TextLCD.h"


AnalogIn sm1(p15);
AnalogIn sm2(p16);
AnalogIn sm3(p17);
AnalogIn sm4(p18);
DigitalOut relay(p30);
Serial GPRS(p9,p10);
Serial uart(p13,p14);
Serial pc(USBTX, USBRX); // tx, rx
TextLCD lcd(p26, p25, p24, p23, p22, p21); // rs, e, d4, d5, d6, d7
LocalFileSystem local("local");
DigitalOut uart_activity(LED2);
char  a=26,e=0x22,c=0x0d,t,ack;
char num[]="9538765141";
float ma;
float s[5],m[5];
int b=100,count;
char col1[]="TIMES",col2[]="SM1",col3[]="SM2",col4[]="SM3",col5[]="SM4";
DigitalOut zig(LED1);
int mz[5];

void SensorRead()
{
 
   lcd.locate(0,0);
   lcd.printf("sensor readings\r");
         s[1]=sm1.read();
         m[1]=(0.057*(s[1]*1024))+25.072;
         lcd.cls();
         lcd.printf("Raw SM1=%0.3f",s[1]); 
         wait(2);
         
         s[2]=sm2.read();
         m[2]=(0.057*(s[2]*1024))+25.072;
         lcd.cls();
         lcd.printf("Raw SM2=%0.3f",s[2]); 
         wait(2);
         
          s[3]=sm3.read();
         m[3]=(0.057*(s[3]*1024))+25.072;
         lcd.cls();
         lcd.printf("Raw SM3=%0.3f",s[3]); 
         wait(2);
         
          s[4]=sm4.read();
         m[4]=(0.057*(s[4]*1024))+25.072;
         lcd.cls();
         lcd.printf("Raw SM4=%0.3f",s[4]); 
         wait(2);
         
         ma=(m[1]+m[2]+m[3]+m[4])/4;
         lcd.locate(0,0);
         lcd.printf("average value is=%f\n\r",ma);
         wait(2);
}

void xlfile()
{        
        //Local storage (On board flash memory of 2MB) 
        count++;
        FILE *fp=fopen("/local/KAEMS.csv","a");
        fprintf(fp,"%d,%0.3f,%0.3f,%0.3f,%0.3f,%0.3f\n",count,m[1],m[2],m[3],m[4],m);
        fclose(fp);
        lcd.cls();
        lcd.printf("File updated");
        wait(2);
}
       //Realy control
void RelayControl() 
{      
        if(ma>40)
        relay=0;
        else
        relay=1;
        wait(2); 
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Relay Function...");
        wait(2);
}

void Upload()
{
        //GPRS commands
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Updating KAEMS...");
        wait(3);
        GPRS.printf("AT+SAPBR=0,1\r\n");
        wait(3);
        GPRS.printf("AT+SAPBR=3,1,%cCONTYPE%c,%cGPRS%c\r\n",e,e,e,e);
        wait(3);
        GPRS.printf("AT+SAPBR=3,1,%cAPN%c,%cAIRCELGPRS.COM%c\r\n",e,e,e,e);
        wait(3);
        GPRS.printf("AT+SAPBR=1,1\r\n");
        wait(3);
        GPRS.printf("AT+HTTPINIT\r\n");
        wait(2);
        GPRS.printf("AT+HTTPPARA=%cCID%c,1\r\n",e,e);
        wait(2);
        GPRS.printf("AT+HTTPPARA=%cURL%c,%chttp://kaems.org/update.php?u=3&t=23&h=34&s1=%f&s2=%f&s3=%f&s4=%f&ph=5&b=%d%c\r\n",e,e,e,m[1],m[2],m[3],m[4],b--,e);
        wait(2);
        GPRS.printf("AT+HTTPDATA=1000,5000\r\n"); 
        wait(10);
        GPRS.printf("AT+HTTPACTION=1\r\n"); 
        wait(5);
        GPRS.printf("AT+HTTPTERM\r\n");
        wait(5);
        
        
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("KAEMS UPDATED");
        wait(3);
}

void SendMessage()
{
         lcd.cls();
        lcd.locate(0,0);
        lcd.printf("SENDING MESSAGE");
        if(ma<40)
        {
            GPRS.printf("AT+CMGS=%c%s%c\r\n",e,num,e);
            wait(3);
            GPRS.printf(" WATER LEVEL IS LOW \nMoisture IS %f \r\n",ma);
            wait(1);
            GPRS.printf("%c",a);
            wait(2);
        }
        if(ma>40)
        
        {
             GPRS.printf("AT+CMGS=%c%s%c\r\n",e,num,e);
            wait(3);
            GPRS.printf(" land has sufficicient amount of water \n Moisture IS %f \r\n",ma);
            wait(1);
            GPRS.printf("%c",a);
            wait(2);
        }    
}
//zigbee sending
void Zigbee()
{
        while(!uart.writeable())         // send thde signal to slave to indacate that the remote station is ready
        {}
        uart.printf("r");
         lcd.cls();
        lcd.printf("command sent");
        wait(5);
        if(uart.readable())              //recieve the signal from remote station
        { 
       
            ack=uart.getc();
            lcd.cls();
            lcd.printf("recieved ack is %c",ack);
        }
        
        if(ack =='s')
        {    
        for(int i=1;i<5;i++)  
        {
             mz[i]=m[i];
             while(!uart.writeable())
             {}
           
             uart.printf("%c",mz[i]);
             wait(1);
             lcd.cls();
             zig=!zig;
             lcd.printf("Zigbee sent a value=%d",mz[i]);
             wait(3);
         }
          }
}
       
       
int main()
{
         GPRS.baud(9600);
         GPRS.printf("AT+CMGF=1\r\n");
         GPRS.printf("AT\n");
         wait(3);
         lcd.locate(0,0);
         lcd.printf("SYSTEM IS ON\n\r");
         wait(1);
         FILE *fp=fopen("/local/KAEMS.csv","a");
         fprintf(fp,"%s,%s,%s,%s,%s\n",col1,col2,col3,col4,col5);
         fclose(fp);
         
    while(1)
    {
        SensorRead();
        xlfile();
       // Zigbee();
        RelayControl();
        Upload(); 
        SendMessage();
        wait(3600);
    }
}    


