#include "mbed.h"
#include "TextLCD.h"
#include "CRotaryEncoder.h"

#define DAC_ADDR (0xc0)
#define ADC_ADDR (0xD0) 
#define BlankString "                    "

//bool DEBUGON = 1;
bool DEBUGON = 0;

bool TxEmpty = 0;
bool SerialAvailable = 0;
uint8_t r0,r1,r2,r3,r4,r5,r6,r7;
uint8_t ChRead;  
char SerialBuffer[50];

Ticker OneSecTicker;
uint8_t CursorPos = 0;

I2C i2c(D4,D5); //I2C i2c(I2C_SDA, I2C_SCL);

//InterruptIn EncoderButton(PA_7);
DigitalIn EncoderButton(PA_7);

TextLCD lcd(D12, D11, D10, D9, D8, D7,TextLCD::LCD20x4); // rs, e, d4-d7
CRotaryEncoder Encoder(D3,D6);  //PinA,PinB
int EncoderCount = 0;

DigitalOut MCP4728Ldac(PA_6,1);
DigitalIn  MCP4728Rdy(PA_5);
static uint16_t DACvalue = 0;

Ticker HMSec;
uint8_t NowChannel=0;

char Buffer[21];

DigitalOut myled(LED1);

//Serial pc(SERIAL_TX, SERIAL_RX);
Serial Rs232(PA_9, PA_10);

/*
typedef struct {
    __IO uint32_t FIODIR;
    uint32_t RESERVED0[3];
    __IO uint32_t FIOMASK;
    __IO uint32_t FIOPIN;
    __IO uint32_t FIOSET;
    __O  uint32_t FIOCLR;
} LPC_GPIO_TypeDef;
*/
typedef struct {
    uint16_t Ch0;
    uint16_t Ch1;
    uint16_t Ch2;
    uint16_t Ch3;
} StructDAC;

typedef struct {
    uint16_t    HexData[4];
    float       RealData[4];
    float       CalibData[4];
} StructADC;

StructADC ADCData;
StructDAC DACData;

 
bool mcp4728_setChannel(uint8_t channel, bool UseInternalVRef, uint8_t powerDownMode, bool use2xGain, uint16_t value){
    char buf[3];
    buf[0] = 0x40 | ((channel & 0x3) << 1);
    
    buf[1] = ((uint8_t)UseInternalVRef << 7) | ((powerDownMode & 0x3) << 5) | ((uint8_t)use2xGain << 4);
    buf[1] |= (value & 0x0f00)>>8;
    
    buf[2] = value & 0xff;
    
    return i2c.write(DAC_ADDR, buf, 3, 0) == 0;
}
 
int dac_test(void){
//    static uint16_t value = 0;
    int ret;
    
//    MCP4728Ldac = 0;
if(DACvalue == 0xfff) DACvalue = 0;
else DACvalue = 0xfff;
    ret = mcp4728_setChannel(0, 1, 0, 1, DACvalue);
//    DACvalue += 4;
//    MCP4728Ldac = 1;

    if(!ret) return -2;
    
    return 1;
}

void EncoderButtonPressed(){
int cnt;
    cnt = Encoder.Get();
    cnt += 10;    
    Encoder.Set(cnt);
    if(DEBUGON) DEBUGON = 0;
        else DEBUGON = 1;
}
void SetDAC(uint8_t ChNo,uint16_t Value){
    switch(ChNo){
        case 0:
            DACData.Ch0 = Value;
            mcp4728_setChannel(0, 1, 0, 1, Value);
            break;
        case 1:
            DACData.Ch1 = Value;
            mcp4728_setChannel(1, 1, 0, 1, Value);
            break;
        case 2:
            DACData.Ch2 = Value;
            mcp4728_setChannel(2, 1, 0, 1, Value);
            break;
        case 3:
            DACData.Ch3 = Value;
            mcp4728_setChannel(3, 1, 0, 1, Value);
            break;
        }
}
void UpdateDAC(){
    mcp4728_setChannel(0, 1, 0, 1, DACData.Ch0);
    mcp4728_setChannel(1, 1, 0, 1, DACData.Ch1);
    mcp4728_setChannel(2, 1, 0, 1, DACData.Ch2);
    mcp4728_setChannel(3, 1, 0, 1, DACData.Ch3);
}
void ResetDAC(){
    DACData.Ch0 = 0;
    DACData.Ch1 = 0;
    DACData.Ch2 = 0;
    DACData.Ch3 = 0;
    UpdateDAC();
}
void FullDAC(){
    DACData.Ch0 = 0xfff;
    DACData.Ch1 = 0xfff;
    DACData.Ch2 = 0xfff;
    DACData.Ch3 = 0xfff;
    UpdateDAC();
}
bool mcp3428_writeConfig(uint8_t conf){
    return i2c.write(ADC_ADDR, (char*) &conf, 1, 0) == 0;
}
 
bool mcp3428_read(uint16_t* data, uint8_t* conf){
    char buf[3];
    int ret = i2c.read(ADC_ADDR, buf, 3, 0);
    if(ret != 0)
        return false;
    *data = buf[0] << 8 | buf[1];
    *conf = buf[2];
    return true;
}

int ReadADC(uint8_t ChNo){
uint8_t conf = 0x98;
uint16_t data = 0;


    switch(ChNo){
        case 0:
            conf = 0x98;
            break;
        case 1:
            conf = 0xb8;
            break;
        case 2:
            conf = 0xd8;
            break;
        case 3:
            conf = 0xf8;
            break;
        }
    if(!mcp3428_writeConfig(conf)) return -1;
    wait(0.1);
    int ret = mcp3428_read(&data, &conf);
//if(DEBUGON)    Rs232.printf("CONF: %02x    ChannelNo: %02d \n",conf,ChNo);
    if(!ret) return -2; 
    return data;
}
void ConvertNegative(uint8_t ChNo,int d){
    if(d & 0x8000) {
        d &= 0x7fff;
        d = (d ^ 0x07fff) + 1;
        ADCData.HexData[ChNo] = d;
        ADCData.RealData[ChNo] = ADCData.HexData[ChNo] * ADCData.CalibData[1] / 32768.0;  
        ADCData.RealData[ChNo] *= (-1.0);
        }
    else{   
        ADCData.HexData[ChNo] = d;
        ADCData.RealData[ChNo] = ADCData.HexData[ChNo] * ADCData.CalibData[ChNo] / 32768.0;  
        }
}
void ReadADCConverted(){
int adData=0;
bool Negative=0;

    adData = ReadADC(0);
    if ( (adData == -1) || (adData == -2) ) goto next1;
    ConvertNegative(0,adData);  
next1:
    adData = ReadADC(1);
    if ( (adData == -1) || (adData == -2) ) goto next2;
    ConvertNegative(1,adData);   
next2:
    adData = ReadADC(2);
    if ( (adData == -1) || (adData == -2) ) goto next3;
    ConvertNegative(2,adData);   
next3:
    adData = ReadADC(3);
    if ( (adData == -1) || (adData == -2) ) goto next4;
    ConvertNegative(3,adData);   
next4:
    return;
}
/*
void ReadADCTicker(){
uint8_t conf = 0x98;
uint16_t data = 0;

    switch(NowChannel){
        case 0:conf = 0x98;break;
        case 1:conf = 0xb8;break;
        case 2:conf = 0xd8;break;
        case 3:conf = 0xf8;break;
        }

    int ret = mcp3428_read(&data, &conf);
    if(!ret) goto NextCh;
//    mcp3428_read(&data, &conf);
    ADCData.HexData[NowChannel] = data & 0x7fff;

    ADCData.RealData[NowChannel] = ( (ADCData.HexData[NowChannel] * ADCData.CalibData[NowChannel] / 32768.0) ); 
NextCh:
    NowChannel++;
    if(NowChannel > 3) NowChannel = 0;
    
    switch(NowChannel){
        case 0:conf = 0x98;break;
        case 1:conf = 0xb8;break;
        case 2:conf = 0xd8;break;
        case 3:conf = 0xf8;break;
        }
    mcp3428_writeConfig(conf);
  
}
*/
int adc_test(void){
//    uint8_t conf = 0x90;
    uint8_t conf = 0x98;
    uint16_t data = 0;
    
    if(!mcp3428_writeConfig(conf)) return -1;
    
    int ret = mcp3428_read(&data, &conf);
    
    if(!ret) return -2;
    
    return data;
    
    }
void HMSecRoutine(){
//    ReadADCTicker();
}
void LCDPrintDataADC(){
//    lcd.cls();
    sprintf(Buffer,"Ch1: %6.3f V",ADCData.RealData[0]);
    lcd.locate(0,0);
    lcd.printf(BlankString);
    lcd.locate(0,0);
    lcd.printf(Buffer);

    sprintf(Buffer,"Ch2: %6.3f V",ADCData.RealData[1]);
    lcd.locate(0,1);
    lcd.printf(BlankString);
    lcd.locate(0,1);
    lcd.printf(Buffer);

    sprintf(Buffer,"Ch3: %6.3f V",ADCData.RealData[2]);
    lcd.locate(0,2);
    lcd.printf(BlankString);
    lcd.locate(0,2);
    lcd.printf(Buffer);

    sprintf(Buffer,"Ch4: %6.3f V",ADCData.RealData[3]);
    lcd.locate(0,3);
    lcd.printf(BlankString);
    lcd.locate(0,3);
    lcd.printf(Buffer);

//        Rs232printf("adc_test: %5.3f %5.3f %5.3f %5.3f\n", ADCData.RealData[0],ADCData.RealData[1],ADCData.RealData[2],ADCData.RealData[3]);


}
void LCDPrintDataDAC(){
//    lcd.cls();
    sprintf(Buffer," Ch1: %4d",DACData.Ch0);
    lcd.locate(0,0);
    lcd.printf(BlankString);
    lcd.locate(0,0);
    lcd.printf(Buffer);

    sprintf(Buffer," Ch2: %4d",DACData.Ch1);
    lcd.locate(0,1);
    lcd.printf(BlankString);
    lcd.locate(0,1);
    lcd.printf(Buffer);

    sprintf(Buffer," Ch3: %4d",DACData.Ch2);
    lcd.locate(0,2);
    lcd.printf(BlankString);
    lcd.locate(0,2);
    lcd.printf(Buffer);

    sprintf(Buffer," Ch4: %4d",DACData.Ch3);
    lcd.locate(0,3);
    lcd.printf(BlankString);
    lcd.locate(0,3);
    lcd.printf(Buffer);

    while(EncoderButton == 0);

}

void DisplayCursor(){
    
    switch(CursorPos){
        case 0:
            lcd.locate(0,0);lcd.printf(">");
            lcd.locate(0,1);lcd.printf(" ");
            lcd.locate(0,2);lcd.printf(" ");
            lcd.locate(0,3);lcd.printf(" ");
            break;
        case 1:
            lcd.locate(0,0);lcd.printf(" ");
            lcd.locate(0,1);lcd.printf(">");
            lcd.locate(0,2);lcd.printf(" ");
            lcd.locate(0,3);lcd.printf(" ");
            break;
        case 2:
            lcd.locate(0,0);lcd.printf(" ");
            lcd.locate(0,1);lcd.printf(" ");
            lcd.locate(0,2);lcd.printf(">");
            lcd.locate(0,3);lcd.printf(" ");
            break;        
        case 3:
            lcd.locate(0,0);lcd.printf(" ");
            lcd.locate(0,1);lcd.printf(" ");
            lcd.locate(0,2);lcd.printf(" ");
            lcd.locate(0,3);lcd.printf(">");
            break;            
        }
    }
void ProcessEncoder(){
uint16_t val;
    switch(CursorPos){
        case 0: val = DACData.Ch0;break;
        case 1: val = DACData.Ch1;break;
        case 2: val = DACData.Ch2;break;
        case 3: val = DACData.Ch3;break;
        }
    Encoder.Set(val);
here:
    val = Encoder.Get();
    lcd.locate(0,3);
    lcd.printf("%04d",val);
    if(Encoder.Get() < 0) Encoder.Set(0);
    if(Encoder.Get() > 4095) Encoder.Set(4095);
    if(EncoderButton == 0){
        while(EncoderButton == 0);
        val = Encoder.Get();
        switch(CursorPos) {
            case 0:
                DACData.Ch0 = val;
                SetDAC(0,DACData.Ch0);
                break;
            case 1:
                DACData.Ch1 = val;
                SetDAC(1,DACData.Ch1);
                break;
            case 2:
                DACData.Ch2 = val;
                SetDAC(2,DACData.Ch2);
                break;
            case 3:
                DACData.Ch3 = val;
                SetDAC(3,DACData.Ch3);
                break;
        }
        return;
        }
    goto here;
}    
void SetTheDacData(){
    lcd.cls();
    lcd.locate(0,2);
    switch(CursorPos){
        case 0:lcd.printf("Set CH%02d Value",CursorPos+1);break;
        case 1:lcd.printf("Set CH%02d Value",CursorPos+1);break;
        case 2:lcd.printf("Set CH%02d Value",CursorPos+1);break;
        case 3:lcd.printf("Set CH%02d Value",CursorPos+1);break;
        }
    ProcessEncoder();
}    
void SetDac(){
int ECount;
    CursorPos = 0;
here1:
    Encoder.Set(CursorPos);
    LCDPrintDataDAC();
    while(1){
        ECount = Encoder.Get();
        if(ECount > 3){ECount = 0;CursorPos = 0;Encoder.Set(CursorPos);return;}
        else { CursorPos = ECount;Encoder.Set(CursorPos);}
        DisplayCursor();
        if(EncoderButton == 0){
            while(EncoderButton == 0);
            SetTheDacData();
            goto here1;
            }
        }
}

void PushToBuffer(){
    r0 = r1;
    r1 = r2;
    r2 = r3;
    r3 = r4;
    r4 = r5;
    r5 = r6;
    r6 = r7;
    r7 = ChRead;
    if((r0==':')&&(r7==';')) SerialAvailable = 1;
} 

void Rx_interrupt() {
    while(Rs232.readable()){
        ChRead = Rs232.getc();        
        PushToBuffer();
        }
}

void Tx_interrupt() {
//    TxEmpty = 1;
    return;
}

void SendSerial(){
uint8_t ch,i;
    TxEmpty = 1;
    for(i=0;i<=49;i++){
        ch = SerialBuffer[i];
        if(ch == 0){
            while(!TxEmpty);
            TxEmpty = 0;
            Rs232.putc(0x0d);
            while(!TxEmpty);
            TxEmpty = 0;
            Rs232.putc(0x0a);
            return;
            }
        while(!TxEmpty);
        TxEmpty = 0;         
        Rs232.putc(ch);
    }
      
} 
void SerialDataSend(){
    Rs232.printf("ADCChannels: %6.3f %6.3f %6.3f %6.3f\n", ADCData.RealData[0],ADCData.RealData[1],ADCData.RealData[2],ADCData.RealData[3]);
}
void PrintRs232(){
    lcd.cls();
    lcd.locate(0,2);lcd.printf("SerialCommand");
    lcd.locate(0,3);lcd.putc(r0);
    lcd.locate(1,3);lcd.putc(r1);
    lcd.locate(2,3);lcd.putc(r2);
    lcd.locate(3,3);lcd.putc(r3);
    lcd.locate(4,3);lcd.putc(r4);
    lcd.locate(5,3);lcd.putc(r5);
    lcd.locate(6,3);lcd.putc(r6);
    lcd.locate(7,3);lcd.putc(r7);
}
void SetSerialDAC(){
uint8_t ch;
uint16_t val;
    ch = r2 - '0';
    val = (r3 - '0')*1000;
    val += (r4 - '0')*100;
    val += (r5 - '0')*10;
    val += (r6 - '0')*1;
    if(val > 4095) val = 4095;
    if(val < 0) val = 0;
    if((ch >= 0) && (ch < 4)) SetDAC(ch,val); 
        else return; 
}


void ParseCom(){
    if(SerialAvailable){
        PrintRs232();
        switch(r1){
            case '3'://DAC Command Set Value;
                SetSerialDAC();
                break;
            case '4'://DAC Command Set Zero;
                ResetDAC();
                break;
            case '5'://DAC Command Set Full;
                FullDAC();
                break;
            default:break;    
            }
        }
    SerialAvailable = 0;
}
int main() {
uint16_t Counter=0;
//    EncoderButton.fall(&EncoderButtonPressed); 
//    EncoderButton.enable_irq ();  


    Rs232.attach(&Rx_interrupt, Serial::RxIrq);
    Rs232.attach(&Tx_interrupt, Serial::TxIrq);

    OneSecTicker.attach(&SerialDataSend,1.0);

    lcd.cls();
    MCP4728Ldac = 0;
    ResetDAC();
//ForHighVoltageModule    
    ADCData.CalibData[0] = 10.08;
    ADCData.CalibData[1] = 10.079;
    ADCData.CalibData[2] = 10.096;
    ADCData.CalibData[3] = 10.095;

    DACData.Ch0 = 0;
    DACData.Ch1 = 0;
    DACData.Ch2 = 0;
    DACData.Ch3 = 0;

    lcd.locate(0,0);
//    lcd.printf("Test Jig Module ");
    lcd.printf("4 Ch HV Module ");
    wait(2);
    
    while(1){
        ReadADCConverted();
        LCDPrintDataADC();
        ParseCom();
        if(EncoderButton == 0){
            SetDac();
            }        
        wait(1);
        myled = !myled;
    }

}



 
 

 
