#include "mbed.h"
#include "ESP8266.h"
 
Serial pc(USBTX,USBRX);
DigitalOut rled(LED1);

//wifi UART port and baud rate
ESP8266 wifi(PTE0, PTE1, 115200);    // Class Variable Pin dexlaration for WIFI

//buffers for wifi library
char snd[255],resp[9000];
char http_cmd[300], comm[300];
char url_response[9000];

int timeout = 5000; //timeout for wifi commands

//SSID and password for connection 
#define SSID "Karkhana"     
#define PASS "Karkhana2018"  
void control_led(void);
//Remote IP
#define IP "184.106.153.149"          // IP for thingspeak server. Remains same for al codes using thingspeak
//#define IP "192.168.0.25"
//waterlevelue global variable
int ledstatus=0;

//Public and private keys for phant
char* Update_Key = "OPETON9L7UP3FCOP";                   // Copy the read key for your channel and paste it here.
//char* Private_Key = "GPoWnRM60yidrB0e1pXD";
 
//Wifi init function. Sets the module to connect to wifi accesspoint with ssid and password mentioned above
void wifi_initialize(void){
    
    pc.printf("******** Resetting wifi module ********\r\n");
    wifi.Reset();
    
    //wait for 5 seconds for response, else display no response receiveed
    if (wifi.RcvReply(resp, 5000))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response");
    
    pc.printf("******** Setting Station mode of wifi with AP ********\r\n");
    wifi.SetMode(1);    // set transparent  mode
    if (wifi.RcvReply(resp, timeout))    //receive a response from ESP
        pc.printf("%s",resp);    //Print the response onscreen
    else
        pc.printf("No response while setting mode. \r\n");
    
    pc.printf("******** Joining network with SSID and PASS ********\r\n");
    wifi.Join(SSID, PASS);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);   
    else
        pc.printf("No response while connecting to network \r\n");
        
    pc.printf("******** Getting IP and MAC of module ********\r\n");
    wifi.GetIP(resp);     
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while getting IP \r\n");
    
    pc.printf("******** Setting WIFI UART passthrough ********\r\n");
    wifi.setTransparent();          
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting wifi passthrough. \r\n");
    wait(1);    
    
    pc.printf("******** Setting single connection mode ********\r\n");
    wifi.SetSingle();             
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while setting single connection \r\n");
    wait(1);
}

void wifi_send(void){
    
    pc.printf("******** Starting TCP connection on IP and port ********\r\n");
    wifi.startTCPConn(IP,80);    //cipstart
    wifi.RcvReply(resp, timeout);
    if (wifi.RcvReply(resp, timeout))    
        pc.printf("%s",resp);    
    else
        pc.printf("No response while starting TCP connection \r\n");
    wait(1);
    
    //create link      
    sprintf(http_cmd,"/channels/500979/fields/1.json?api_key=%s&results=2",Update_Key);              // Forms the url for transmitting to thingspeak server. the format can be seen on thingspeak site as well
    pc.printf(http_cmd);
    
    pc.printf("******** Sending URL to wifi ********\r\n");
    wifi.sendURL(http_cmd, comm);   //cipsend and get command
    if (wifi.RcvReply(resp, timeout)){
        pc.printf("--------------------------Request Response -------------------------------------------\r\n");   
        pc.printf("%s",resp);
        pc.printf("--------------------------Request Response -------------------------------------------\r\n");
        control_led();   
        } 
    else
        pc.printf("No response while sending URL \r\n");
    
    //wifi.SendCMD("AT+CIPCLOSE"); //Close the connection to server
    //wifi.RcvReply(resp, timeout);
    //pc.printf("%s", resp);
}

void control_led(void)
{
    int length=strlen(resp);
    pc.printf("Length of response: %d\r\n",strlen(resp));
    ledstatus=int(resp[length-13]);
    pc.printf("LED Status is %c\r\n",resp[length-13]);
    pc.printf("LED status is %d\r\n",ledstatus);
    if(resp[length-13]==49){
        pc.printf("LED ON");
        rled=0;
        }
    else{
        pc.printf("LED OFF");
        rled=1;
        }
}
        

int main () {
    
    
    wifi_initialize();   // Calls function defined above to initialize the wifi module
    
    while (1) {        
        wifi_send();   // Calls function defined above to send data to thingspeak
        //wait(5);
    }
}