/**
  Copyright (c) 2020 https://www.esmacat.com/

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  EsmacatShield.cpp - Library for using EtherCAT Arduino Shield by Esmacat(EASE).
  Created by Esmacat, 01/22/2020

*******************************************************************************
* @file EsmacatShield.cpp
*******************************************************************************
*/

#include "EsmacatShield.h"

EsmacatShield::EsmacatShield(SPI &spi, DigitalOut &pin):ecat_spi(spi),ecat_cs(pin) 
{
     
}

void EsmacatShield::setup_spi()
{
    /*Chip must be deselected*/
    ecat_cs = 1;

  /*Setup the spi for 8 bit data, Mode 1,
    with a 3MHz clock rate*/
    ecat_spi.format(8,1);
    ecat_spi.frequency(3000000);
    
    /* Chip must be selected*/
    ecat_cs = 0;

}


void EsmacatShield::write_reg_value(int write_addr, int16_t value, bool led_on)
{
  uint8_t v1,v2;
  // Chip must be selected
  ecat_cs = 0;
  wait_us(2000);                       //sleep for 2 ms;
  write_addr = write_addr <<3;
  if (led_on)
  {
    ecat_spi.write(((EASE_WRITE_REG|write_addr)| EASE_LED_ON)& EASE_SINGLE_SHOT);
  }
  else
  {
    ecat_spi.write((EASE_WRITE_REG|write_addr)& EASE_LED_OFF & EASE_SINGLE_SHOT); 
  }
  v1 = (value&0xFF00) >> 8;
  v2 = (value&0x00FF);
  ecat_spi.write(v1);
  ecat_spi.write(v2);
  // Chip must be deselected
  ecat_cs = 1;
  wait_us(2000);                       //sleep for 2 ms;
}

int16_t* EsmacatShield::get_ecat_registers(int16_t regs[8]) {
  regs[0] = read_reg_value(1);
  regs[1] = read_reg_value(2);
  regs[2] = read_reg_value(3);
  regs[3] = read_reg_value(4);
  regs[4] = read_reg_value(5);
  regs[5] = read_reg_value(6);
  regs[6] = read_reg_value(7);
  regs[7] = read_reg_value(0);
  return(regs);
}

int16_t EsmacatShield::read_reg_value(int16_t read_addr)
{
  uint16_t v2,v3;
  // Chip must be selected
  ecat_cs = 0;
  wait_us(2000);                       //sleep for 2 ms;
  read_addr = read_addr <<3;
  ecat_spi.write( EASE_READ_REG|read_addr);
  v2 = ecat_spi.write(0x00);
  v3 = ecat_spi.write(0x00);
  // Chip must be deselected
  ecat_cs = 1;
  wait_us(2000);                      //sleep for 2 ms;

  return (v2<<8)+v3;
}

EsmacatShield::~EsmacatShield(void) 
{
  //empty block
}
 
