/**
 ******************************************************************************
 * @file    main.cpp
 * @date    February 06, 2020
 * @brief   mbed test application - Esmacat Shield(EASE) working together with 
 *          Base Board with Arduino UNO form factor as EtherCAT slave.
 *          With the successful execution of this code the LED on EASE should
 *          blink. It should also estabilish data transfer between the EtherCAT
 *          Master of Esmacat on the PC.
 *          For further information please refer to the tutorials at
 *          https://www.esmacat.com/tutorials 
 ******************************************************************************
 
  Copyright (c) 2020 https://www.esmacat.com/

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  EsmacatShield.h - Library for using EtherCAT Arduino Shield by Esmacat(EASE).
  Created by Esmacat, 01/22/2020
  
*******************************************************************************
* @file EsmacatShield.h
*******************************************************************************
*/
#include "mbed.h"
#include <EsmacatShield.h> //Include EsmacatShield Library


int counter;
int16_t v[8];                  //an array of integer is declared for reading the 
                           //data packet of EtherCAT from EASE 8 registers
Serial pc(USBTX, USBRX);   // Configuring the serial port to host PC

DigitalOut selectPin(D10); // D10 is used to drive chip enable low
SPI spi(D11, D12, D13);    // mosi, miso, sclk


int main() 
{

    EsmacatShield slave(spi, selectPin);  //Create an Esmacat slave object with defined
                                          // spi and chip SelectPin
    
    slave.setup_spi();            //Setup SPI for EASE
    
    while(1)
    {
      slave.get_ecat_registers(v);  //read all registers
      slave.write_reg_value(0,counter++, true);   //Write register data (register,value, led_on)
      wait_us(1000000);                      //sleep for 1000 ms
      slave.write_reg_value(0,counter++, false);   //Write register data (register,value, led_on)
      wait_us(1000000);                      //sleep for 1000 ms
      pc.printf("Next Iteration \n");
      for (int i=0;i<8;i++)         //Print out read registers to host PC terminal
      {
        pc.printf("%d",i);
        pc.printf("  ");
        pc.printf("%d",v[i]);
        pc.printf("\n");
      }
        
    }

}
