 #include "mbed.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);

BusOut rgb(LED1,LED2,LED3);
Serial pc(USBTX,USBRX);

int main() {
    float accy,accz;
    int y,z;
    int count=0;
    rgb=0b111; // turning all leds off
    while(1) {
        //acquiring values of accelerometer
        accy=acc.getAccY();
        accz=acc.getAccZ();
        y=(accy+2)*100;
        z=(accz+2)*100;
        pc.printf("$%d %d;",y,z);
        //detecting movement
        if((accy>1)||(accy<-1)){
                count++;  
                switch(count){
                case 1: rgb=0b110; break;
                case 2: rgb=0b101; break;
                case 3: rgb=0b011; break;
                case 4: rgb=0b000; break;
                case 5: rgb=0b111; count=0; break;
                }
                wait(0.5);
            }
        else if((accz>1)||(accz<-1)){ //detecting if it's left movement 
                count--; 
                switch(count){
                case 1: rgb=0b110; count=6; break;
                case 2: rgb=0b101; break;
                case 3: rgb=0b011; break;
                case 4: rgb=0b000; break;
                case 5: rgb=0b111; break;
                }
                wait(0.5);
            }
    }
}
