//Do NOT edit this file. Thanks!
#include "mbed.h"
#include "define_variables.h"
#include "fmea.h"


///////////////////////////////INPUTS - Throttle, Steering, Brakes//////////////////////////////////////////////
//constant parameters
const float dead_rpm = 10;

// - - - Inputs - - -
//steering and throttle inputs
float steering;                                                         //input steering wheel angle in degrees
float throttle;                                                         //throttle input from pedal

AnalogIn throttle1(p19);
AnalogIn throttle2(p17);
AnalogIn steering1(p20);
AnalogIn steering2(p15);
AnalogIn brake1(p18);
AnalogIn brake2(p16);

Ticker ForAnalogRead;
bool ready_to_read=false;

uint16_t throttle1_value;
uint16_t throttle2_value;
uint16_t steering1_value;
uint16_t steering2_value;
uint16_t brake1_value;
uint16_t brake2_value;

void ReadAnalogInputs()
{
    ready_to_read = true;
}


////////////////////////////////////RPM/////////////////////////////////////////////////

//Opeloop Flag
volatile bool openloop_lowrpm = true;
volatile bool openloop_driver = false;
const float rpm_openloop_limit = 100;

// take interrupts (pins 25 and 23)
InterruptIn wheel_Left_intr(wheel_Left_pin);
InterruptIn wheel_Right_intr(wheel_Right_pin);
InterruptIn wheel_FrontLeft_intr(wheel_FrontLeft_pin);
InterruptIn wheel_FrontRight_intr(wheel_FrontRight_pin);

//rpm counts
volatile int cnt_Left = 0;
volatile int cnt_Right = 0;
volatile int cnt_FrontLeft = 0;
volatile int cnt_FrontRight = 0;

//Left and Right rear RPMs feedback-input 
float rpm_Left;
float rpm_Right;
float rpm_FrontLeft = 100;
float rpm_FrontRight = 100;

//RPM count function
void wheel_Left_interrupt(void);
void wheel_Right_interrupt(void);
void wheel_FrontLeft_interrupt(void);
void wheel_FrontRight_interrupt(void);

//Timer for RPM measurement
//Ticker (for RPM measurement Timer Reset) and corresponding Reset Function
Timer rpm_timer;
Ticker ForTimerReset;
void TimerReset();

//RPM Measurement Timer Readings for Current/Prev pulse of Left/Right Wheel Sensor
volatile int Current_time_Left = 0,Prev_time_Left = 0;
volatile int Current_time_Right = 0,Prev_time_Right = 0;
volatile int Current_time_FrontLeft = 0,Prev_time_FrontLeft = 0;
volatile int Current_time_FrontRight = 0,Prev_time_FrontRight = 0;

//Difference between Timer Readings for consecutive pulses i.e. time for 1 revolution 
volatile float time_elapsed_Left;
volatile float time_elapsed_Right;
volatile float time_elapsed_FrontLeft;
volatile float time_elapsed_FrontRight;

/////////////////////////////////////////////////FMEA//////////////////////////////////////////////////////
//GLOBAL FMEA FLAG - 8 bit
uint8_t FMEAStatusFlags = 0x00;

//FMEA
volatile int fmea_switch=0;

//FMEA output
bool shutdown= false;                                                           //Shutdown Car
bool Dash = false;                                                              //Display Message on Dash - give option to driver to switch to openloop

//Display Indicators for FMEA testing
volatile bool displayLeftrpm = false;
volatile bool displayDash = false;
volatile bool displayLeftdiff = false;
volatile bool displayRightrpm = false;
volatile bool displayRightdiff = false;

//For Missing Teeth RPM FMEA

//Pulse Time measurement variables
volatile int CurrentLeftMissingTeethTimeElapsed=0, PrevLeftMissingTeethTimeElapsed = 0, 
CurrentDiffLeftMissingTeethTimeElapsed = 0,PrevDiffLeftMissingTeethTimeElapsed = 0;

volatile int CurrentRightMissingTeethTimeElapsed=0, PrevRightMissingTeethTimeElapsed = 0, 
CurrentDiffRightMissingTeethTimeElapsed = 0,PrevDiffRightMissingTeethTimeElapsed = 0;

/*

(Current/Prev)(Left/Right)MissingTeethTimeElapsed       -   Timer reading for current/previous pulse of Left/Right RPM pulses
(Current/Prev)Diff(Left/Right)MissingTeethTimeElapsed   -   Difference between timer readings of consecutive pulse 
                                                            i.e. width of current/prev pulse of of Left/Right RPM pulses  
*/

//Flags for starting Left/Right Missing Teeth RPM FMEA
volatile bool MissingTeethCheckRight = false, MissingTeethCheckLeft = true;

//Missing Teeth Count
int countLeftMissingTeeth = 0, countRightMissingTeeth = 0; 

//Ratio between times of consecutive pulses - to check for missing teeth - (will be >=2 in case of missing teeth)
float ratio, ratio1;

//Missing Teeth FMEA Call Function and corresponding Ticker
Ticker ForFmeaCall; 
void FmeaCall();

/////////////////////////////////////////////ISRs KELLY FAULTS, READY SIGNAL/////////////////////////////////////////////////////// 
//Kelly Safety Interrupt. Kelly Green. (Left and Right)
InterruptIn KellyGreenLeft(p26);
InterruptIn KellyGreenRight(p25);
InterruptIn ReadySignal(p11);

bool KellyLeftFault = false;
bool KellyRightFault = false;
bool Ready = false;

void ISRKellyLeftFault()
{
    KellyLeftFault = true;
}

void ISRKellyRightFault()
{
    KellyRightFault = true;
}

void ISRReadyStatus()
{
    Ready = true;
}

////////////////////////////////////////////SPI to EDIFF MAIN//////////////////////////////////
//Fetch Naveen's codes.
#define SPI_BYTE_ARRAY_SIZE 13
SPISlave spi(p5,p6,p7,p8);
InterruptIn cs(p8);

uint8_t SPIDataToMain[SPI_BYTE_ARRAY_SIZE];
int SPIByteCounter = 0;

void PopulateSPIData()
{
    SPIDataToMain[0] = (uint8_t)('@');
    SPIDataToMain[1] = (uint8_t)(steering1_value>>8);
    SPIDataToMain[2] = (uint8_t)(steering2_value>>8);
    SPIDataToMain[3] = (uint8_t)(255-((float)(throttle1_value>>8)/105*255));
    SPIDataToMain[4] = (uint8_t)(255-(((float)(throttle2_value>>8)-5)/135*255));
    SPIDataToMain[5] = (uint8_t)(brake1_value>>8);
    SPIDataToMain[6] = (uint8_t)(brake2_value>>8);
    SPIDataToMain[7] = (uint8_t)(rpm_Left/1000*255);
    SPIDataToMain[8] = (uint8_t)(rpm_Right/1000*255);
    SPIDataToMain[9] = (uint8_t)(rpm_FrontLeft/1000*255);
    SPIDataToMain[10] = (uint8_t)(rpm_FrontRight/1000*255);
    SPIDataToMain[11] = FMEAStatusFlags;
    SPIDataToMain[12] = (uint8_t)('#');    
    //printf("Throttle 1, 2 %u \t %u \n", (uint8_t)(throttle1_value>>8), (uint8_t)(throttle2_value>>8));
    //printf("RPM count %d \n", cnt_Right);
    printf("RPM 1 %f \n", rpm_Right);
}

void SendSPIDataToMain()
{    
    //uint8_t temp;
    //temp = spi.read();
    spi.read();
    spi.reply(SPIDataToMain[SPIByteCounter]);
    SPIByteCounter = (SPIByteCounter + 1)%SPI_BYTE_ARRAY_SIZE;
    if (SPIByteCounter == 0)PopulateSPIData();
}

//////////////////////////////////////////////CAN to DAQ///////////////////////////////////////
//Of no use at present. 

/////////////////////////////////////////////CAN for YAW RATE, STEERING sensors////////////////
//Unavailable.

int main() 
{    
    //Start the wheel rpm timers
    rpm_timer.start();
        
    //Attach Kelly Error, Ready interrupts
    KellyGreenLeft.fall(&ISRKellyLeftFault);
    KellyGreenRight.fall(&ISRKellyRightFault);
    ReadySignal.rise(&ISRReadyStatus);
    
    //FMEA and Timer Reset and AnalogRead Tickers
//    ForFmeaCall.attach(&FmeaCall, 5.0);                             //call Missing Teeth RPM FMEA every 5 sec
    ForTimerReset.attach(&TimerReset,100);                          //Reset RPM measurement timer every 100 sec
    ForAnalogRead.attach(&ReadAnalogInputs,0.1);
     
    //RPM attach functions on rise value: Left, Right, Front Left, Front Right.
//    wheel_Left_intr.rise(&wheel_Left_interrupt);
    wheel_Right_intr.rise(&wheel_Right_interrupt);
//    wheel_FrontLeft_intr.rise(&wheel_FrontLeft_interrupt);
//    wheel_FrontRight_intr.rise(&wheel_FrontRight_interrupt);
    
    //Setup the SPI Slave.
    spi.format(8,3);
    spi.frequency(1000000);
    PopulateSPIData();
    cs.fall(&SendSPIDataToMain);
    
    while(1)
    {
        
        if (ready_to_read) 
        {
            ready_to_read = false;
            throttle1_value=throttle1.read_u16();
            throttle2_value=throttle2.read_u16();
            steering1_value=steering1.read_u16();
            steering2_value=steering2.read_u16();
            brake1_value=brake1.read_u16();
            brake2_value=brake2.read_u16();            
        }
        
        if (openloop_lowrpm && openloop_driver)
        {
            ForFmeaCall.detach();
        }
        
        if (rpm_Right < rpm_openloop_limit || rpm_Left < rpm_openloop_limit)
        {
            openloop_lowrpm = true;
            FMEAStatusFlags |= 0x02; //0b00000010;
        }
        else
        {
            openloop_lowrpm = false;
            FMEAStatusFlags &= 0xFD; //0b11111101; //0b00000000;
        }
    }    
}

//Interrupt Function for measuring Left Wheel RPM and checking Left Sensor Disk Missing Teeth FMEA
void wheel_Left_interrupt()
{
    cnt_Left++;                                                         //Left RPM pulse count
 
    if(cnt_Left >= 12)                                                  //Measure time between 12 holes => 1 revolution
    { 
        Current_time_Left = rpm_timer.read_us();                        //Read Current Timer Reading
        time_elapsed_Left = Current_time_Left - Prev_time_Left;         //Difference between Current and precious Timer readings - time for 1 revolution
        Prev_time_Left = Current_time_Left;                             // Set Current Reading as previous reading for next iteration
        cnt_Left = 0;                                                   //Reset Count
        rpm_Left = 1 / ( time_elapsed_Left  / (1000000*60) );           //Evaluate RPM from time for 1 revolution        
        displayLeftrpm = true;                                          //Display RPM - for testing purposes only
    }
    
    if (MissingTeethCheckLeft && !openloop_lowrpm && !openloop_driver)                                          //Called every 10 sec
    {
         countLeftMissingTeeth++;        
         if (countLeftMissingTeeth == 1)                                //No comparisons for first tooth ( 12th is compared with first)
         {
            PrevLeftMissingTeethTimeElapsed = rpm_timer.read_ms();      // Set Current Timer Reading as previous reading for next iteration
         }
         else  
         {
            CurrentLeftMissingTeethTimeElapsed = rpm_timer.read_ms();    //Read Current Timer Reading
            
            CurrentDiffLeftMissingTeethTimeElapsed = CurrentLeftMissingTeethTimeElapsed - PrevLeftMissingTeethTimeElapsed;  
                                                                         //Difference between Current and precious Timer readings - current pulse time
            PrevLeftMissingTeethTimeElapsed = CurrentLeftMissingTeethTimeElapsed;                          
                                                                         //Set Current Timer Reading as previous reading for next iteration
            ratio = ((float)CurrentDiffLeftMissingTeethTimeElapsed/PrevDiffLeftMissingTeethTimeElapsed);    
                                                                         //Ratio between consecutive pulses
            
            if (ratio > 1.5 || ratio < 1/1.5)                            //If teeth are missing ratio will be >=2
            {
                ratio1 = ratio;
                Dash = true;
                FMEAStatusFlags |= 0x44; //0b01000100;      
                displayDash = true;
            }
            
            PrevDiffLeftMissingTeethTimeElapsed = CurrentDiffLeftMissingTeethTimeElapsed;                 
                                                                         //Set Current pulse time as previous pulse time for next pulse
            displayLeftdiff = true;
        }
        
        if (countLeftMissingTeeth > 13)                                  //Stop once all (12) teeth have been checked
        {
            MissingTeethCheckLeft = false;
            countLeftMissingTeeth = 0;
        }
    }
}

//Interrupt Function for measuring Right Wheel RPM and checking Right Sensor Disk Missing Teeth FMEA
void wheel_Right_interrupt()
{
    printf("Interrupt");
    cnt_Right++;                                                          //Right RPM pulse count
 
    if(cnt_Right >= 12)                                                   //Measure time between 12 holes => 1 revolution
    { 
        Current_time_Right = rpm_timer.read_us();                         //Read Current Timer Reading
        time_elapsed_Right = Current_time_Right - Prev_time_Right;        //Difference between Current and precious Timer readings - time for 1 revolution
        Prev_time_Right = Current_time_Right;                             // Set Current Reading as previous reading for next iteration
        cnt_Right = 0;                                                    //Reset Count
        rpm_Right = 1 / ( time_elapsed_Right  / (1000000*60) );           //Evaluate RPM from time for 1 revolution        
        displayRightrpm = true;                                           //Evaluate RPM from time for 1 revolution
    }
    /*
    if (MissingTeethCheckRight && !openloop_lowrpm && !openloop_driver)                                           //Called every 10 sec
    {
         countRightMissingTeeth++;        
         if (countRightMissingTeeth == 1)                                 //No comparisons for first tooth ( 12th is compared with first)
         {
            PrevRightMissingTeethTimeElapsed = rpm_timer.read_ms();      //Set Current Timer Reading as previous reading for next iteration
         }
         else  
         {
            CurrentRightMissingTeethTimeElapsed = rpm_timer.read_ms();    //Read Current Timer Reading  
            CurrentDiffRightMissingTeethTimeElapsed = CurrentRightMissingTeethTimeElapsed - PrevRightMissingTeethTimeElapsed;  
                                                                          //Difference between Current and precious Timer readings - current pulse time
            PrevRightMissingTeethTimeElapsed = CurrentRightMissingTeethTimeElapsed;
                                                                          //Set Current Timer Reading as previous reading for next iteration
                                                                          
            ratio = ((float)CurrentDiffRightMissingTeethTimeElapsed/PrevDiffRightMissingTeethTimeElapsed);
                                                                          //Ratio between consecutive pulses
            
            if (ratio > 1.5 || ratio < 1/1.5)                             //If teeth are missing ratio will be >=2
            {
                Dash = true;
                FMEAStatusFlags |= 0x24; //0b00100100;
                displayDash = true;
            }
            
            PrevDiffRightMissingTeethTimeElapsed = CurrentDiffRightMissingTeethTimeElapsed;
                                                                         //Set Current pulse time as previous pulse time for next pulse
            displayRightdiff = true;
        }
         
        if (countRightMissingTeeth > 13)                                 //Stop once all (12) teeth have been checked
        {
            MissingTeethCheckRight = false;
            countRightMissingTeeth = 0;
        }
    }*/
}

//Interrupt Function for Left Front Wheel Interrupt to calculate RPM.
void wheel_FrontLeft_interrupt()
{
    cnt_FrontLeft++;                                                                    //Left RPM pulse count
 
    if(cnt_FrontLeft >= 12)                                                             //Measure time between 12 holes => 1 revolution
    { 
        Current_time_FrontLeft = rpm_timer.read_us();                                   //Read Current Timer Reading
        time_elapsed_FrontLeft = Current_time_FrontLeft - Prev_time_FrontLeft;          //Difference between Current and precious Timer readings - time for 1 revolution
        Prev_time_FrontLeft = Current_time_FrontLeft;                                   // Set Current Reading as previous reading for next iteration
        cnt_FrontLeft = 0;                                                              //Reset Count
        rpm_FrontLeft = 1 / ( time_elapsed_FrontLeft  / (1000000*60) );                 //Evaluate RPM from time for 1 revolution
    }
}

//Interrupt Function for Right Front Wheel Interrupt to calculate RPM.
void wheel_FrontRight_interrupt()
{
    printf("Front Right");
    cnt_FrontRight++;                                                                       //Right RPM pulse count
 
    if(cnt_FrontRight >= 12)                                                                //Measure time between 12 holes => 1 revolution
    { 
        Current_time_FrontRight = rpm_timer.read_us();                                      //Read Current Timer Reading
        time_elapsed_FrontRight = Current_time_FrontRight - Prev_time_FrontRight;           //Difference between Current and precious Timer readings - time for 1 revolution
        Prev_time_FrontRight = Current_time_FrontRight;                                     //Set Current Reading as previous reading for next iteration
        cnt_FrontRight = 0;                                                                 //Reset Count
        rpm_FrontRight = 1 / ( time_elapsed_FrontRight  / (1000000*60) );                   //Evaluate RPM from time for 1 revolution
    }
}

//Resets timer for RPM measurement every 100 sec
void TimerReset()
{
    rpm_timer.stop();
    rpm_timer.reset();
    rpm_timer.start();
}

// Sets Flag for starting Left/Right Missing Teeth FMEA after every 5 sec, alternatively
void FmeaCall()
{
    switch (fmea_switch)
    {
        case 0: MissingTeethCheckRight = true;
        break;
        case 1: MissingTeethCheckLeft = true;
        break;
        case 2: rpm_Left_pulldown_fmea();
        break;
        case 3: rpm_Right_pulldown_fmea();
        break;
    }
    fmea_switch++;
    if (fmea_switch == 4)
    {
        fmea_switch = 0;
    }    
}

