#include "fmea.h"

//FMEA - Failure Mode Error Analysis codes.

//FMEA parameters
int fmea_recheck_iteration = 3;
float fmea_recheck_time = 0.3;

//FMEA counters/trackers
int flag_rpm_Left_pulldown = 0;
int flag_rpm_Right_pulldown = 0;

//Ticker for each FMEA function.
Ticker for_rpm_Left_pulldown_fmea;
Ticker for_rpm_Right_pulldown_fmea;

//Left RPM sensor fails. Sensor output is pulled down to zero.
void rpm_Left_pulldown_fmea()
{
    for_rpm_Left_pulldown_fmea.detach();
    if (rpm_Left <= dead_rpm)
    {
        flag_rpm_Left_pulldown++;
        if (flag_rpm_Left_pulldown >= fmea_recheck_iteration)
        {
            Dash = true;
            FMEAStatusFlags |= 0x14; //0b00010100
            return;
        }
        for_rpm_Left_pulldown_fmea.attach(&rpm_Left_pulldown_fmea,fmea_recheck_time);              
    }
    else
    {
        flag_rpm_Left_pulldown = 0;
    }
}

//Right RPM sensor fails. Sensor output is pulled down to zero.
void rpm_Right_pulldown_fmea()
{
    for_rpm_Right_pulldown_fmea.detach();
    if (rpm_Right <= dead_rpm)
    {
        flag_rpm_Right_pulldown++;
        if (flag_rpm_Right_pulldown >= fmea_recheck_iteration)
        {
            Dash = true;
            FMEAStatusFlags |= 0xC; //0b00001100;
            return;
        }
        for_rpm_Right_pulldown_fmea.attach(&rpm_Right_pulldown_fmea,fmea_recheck_time);                   
    }
    else
    {
        flag_rpm_Right_pulldown = 0;
    }
}
