#include "fmea.h"


//FMEA - Failure Mode Error Analysis codes.
//Checks involve the following sensors:
//LEFT THROTTLE, RIGHT THROTTLE, 
//STEERING 1 (CAN Steering Sensor), STEERING 2 (Linear Potentiometer),
//LEFT WHEEL RPM and RIGHT WHEEL RPM.

//FMEA parameters
const float steering_diff_limit = 7;
const float throttle_diff_limit = 0.4;
int fmea_recheck_iteration = 3;
//Give different iteration count to each fmea function later
float fmea_recheck_time = 0.3;


//FMEA counters/trackers
int counter_steering_comparison = 0;
int counter_throttle_comparison = 0;
int counter_steering2_pulldown = 0;
int counter_throttle_Left_limitcross = 0;
int counter_throttle_Right_limitcross = 0;

//Ticker for each FMEA function.
Ticker for_throttle_Left_limitcross_fmea;
Ticker for_throttle_Right_limitcross_fmea;
Ticker for_steering2_pulldown_fmea;
Ticker for_steering_comparison_fmea;

//Left Throttle sensor fails. Sensor output is pulled down to zero.
void throttle_Left_limitcross_fmea()
{
    for_throttle_Left_limitcross_fmea.detach(); 
    if (throttle_Left > 4.8)                                                                        //check upper bound in offline testing
    {
        counter_throttle_Left_limitcross++;
        if (counter_throttle_Left_limitcross >= fmea_recheck_iteration)
        {
            shutdown = true;
            throttleLeftlimitcross = true;
            FMEALowByte|= 0x21; //0b0010 0001
            return;
        }
        for_throttle_Left_limitcross_fmea.attach(&throttle_Left_limitcross_fmea,fmea_recheck_time);                   
    }
    else
    {
        counter_throttle_Left_limitcross = 0;
    }
}

//Right Throttle sensor fails. Sensor output is pulled down to zero.
void throttle_Right_limitcross_fmea()
{
    for_throttle_Right_limitcross_fmea.detach();
    if (throttle_Right > 4.8)                                                   //again check upper limit
    {
        counter_throttle_Right_limitcross++;
        if (counter_throttle_Right_limitcross >= fmea_recheck_iteration)
        {
            shutdown = true;
            throttleRightlimitcross = true;
            FMEALowByte|= 0x22; //0b0010 0010
            return;
        }
        for_throttle_Right_limitcross_fmea.attach(&throttle_Right_limitcross_fmea,fmea_recheck_time);         
    }
    else
    {
        counter_throttle_Right_limitcross = 0;
    }
}

//Steering Sensor 2 (Potentiometer) fails. Sensor output is pulled down to zero.
void steering2_pulldown_fmea()
{
    for_steering2_pulldown_fmea.detach();
    if (steering2 < 0.1)
    {
        counter_steering2_pulldown++;
        if (counter_steering2_pulldown >= fmea_recheck_iteration)
        {
            useBoschSteeringRequest = true;
            FMEALowByte|= 0xC0; //0b1100 0000
            return;
        }
        for_steering2_pulldown_fmea.attach(&steering2_pulldown_fmea,fmea_recheck_time);                  
    }
    else
    {
        shutdown = true;
        FMEALowByte|= 0x24; //0b0010 0100
        steeringComparisonFailure = true;
    }
}

//Check for consistency of the two differently obtained steering values.
void steering_comparison_fmea()
{
    if (!useBoschSteeringDriverApproval)
    {
        for_steering_comparison_fmea.detach(); 
        if (abs(steering2-steering) > steering_diff_limit)
        {
           counter_steering_comparison++;
           if (counter_steering_comparison >= fmea_recheck_iteration) 
           {
               steering2_pulldown_fmea();
               return;
           }
           for_steering_comparison_fmea.attach(&steering_comparison_fmea,fmea_recheck_time); 
        }
        else
        {
           counter_steering_comparison = 0;        
        }
    }
}

//Check for consistency of the two differently obtained throttle values.
void throttle_comparison_fmea()
{
    if (abs(throttle2-throttle) > throttle_diff_limit)
    {
        shutdown = true;
        throttleComparisonFailure = true;
        FMEALowByte|= 0x28; //0b0010 1000    
    }
}


void mux_feedback_fmea()
{
    //throttle left
    if (abs((unsigned short) (throttle_Left * 65535/5) - throttleLeftMux) > 0x0fff)
    {
        shutdown = true;
        throttleLeftDACFailure = true;
        FMEALowByte|= 0x20; //0b0010 0000
        FMEAHighByte|= 0x01; //0b0000 0001    
    }
    
    //throttle right
    if (abs((unsigned short) (throttle_Right * 65535/5) - throttleRightMux) > 0x0fff)
    {
        shutdown = true;
        throttleRightDACFailure = true;
        FMEALowByte|= 0x20; //0b0010 0000
        FMEAHighByte|= 0x02; //0b0000 0010    
    }
}