#ifndef DEFINEVARIABLES_H
#define DEFINEVARIABLES_H

#include "mbed.h"
#include "steering.h"
#define throttle_Left_pwm_pin  p22
#define throttle_Right_pwm_pin p21

#define algoperiod 100000                         //entire algo (pid + steering
#define fmeatime 

extern volatile uint8_t flagsFromICAP;

//car parameters
extern const float trackwidth; 
extern const float wheelradius; 
extern const float rear_wheelbase;

//constant parameters
extern const float full_throttle;
extern const float dead_steering;
extern const float dead_rpm;
extern const float integral_saturation;

//steering, brake and throttle inputs
extern float steering;          //input steering angle
extern float throttle;          //throttle input from pedal
extern float brake;

//spare sensors
extern float steering2, throttle2, yaw_rate;
extern float yaw_rate_desired;
extern float brake2;

//delta_Left, delta_Right, turnradius and wratio_desired calculated realtime from delta (delta_Left and delta_Right are Left and Right tyre angles)
extern float delta_Left;        //Left wheel Steer angle
extern float delta_Right;       //Right wheel Steer angle
extern float turnradius;
extern float wratio_desired;    //Right/Left

// output values
// assumed range of output 0-5V
extern float throttle_Left, throttle_Right, throttle_Left_pulsewidth, throttle_Right_pulsewidth;

extern Ticker check;
//Left and Right rear RPMs feedback-input 
extern float rpm_Left;
extern float rpm_Right;

//Openloop Flag
extern volatile bool openloop_lowrpm;
extern volatile bool openloop_driver;
extern const float rpm_openloop_limit;

//PID constants
extern float kp;
extern float kd;
extern float ki;
extern float c;

//For PID
extern const float timeint;
extern float integral;
extern float derivative;
extern float error_prev;        //error at t0
extern float error_new;         //error at t
extern float wratio_actual;
extern float w_ratio;           //ratio of controller voltages - Right/Left

//------------MUX----------------
extern unsigned short currentLeftMux;
extern unsigned short currentRightMux;
extern unsigned short tempLeftMux;
extern unsigned short tempRightMux;
//extern unsigned short brakeLeftMux;
//extern unsigned short brakeRightMux;
extern unsigned short throttleLeftMux;
extern unsigned short throttleRightMux;

//fmea output
extern bool throttleLeftDACFailure;
extern bool throttleRightDACFailure;
extern bool throttleLeftlimitcross;
extern bool throttleRightlimitcross;
extern bool throttleComparisonFailure;
extern bool steeringComparisonFailure;
extern bool useBoschSteeringRequest;
extern bool useBoschSteeringDriverApproval;
extern bool shutdown;
extern bool Dash;
extern uint8_t FMEALowByte;
extern uint8_t FMEAHighByte;
#endif