//EDiffDAC.h

#ifndef DAC_H
#define DAC_H

#include "mbed.h"

//all commands recognised by the DAC over SPI
#define WRITE_INPUT_REGISTER 0x00
#define WRITE_CONTENTS_OF_INPUT_REGISTER_TO_DAC_REGISTER 0x01
#define WRITE_TO_INPUT_REGISTER_AND_UPDATE_ALL_DAC_REGISTERS 0x02
#define WRITE_TO_INPUT_REGISTER_AND_UPDATE_DAC_REGISTER 0x03
#define POWER_DOWN_DAC 0x04
#define POWER_UP_DAC 0x04
#define LOAD_CLEAR_CODE_REGISTER 0x05
#define LOAD_LDAC_REGISTER 0x06
#define RESET 0x07

//All address bits as defined in the DAC datasheet
#define DAC_A 0x00
#define DAC_B 0x01
#define DAC_C 0x02
#define DAC_D 0x03
#define ALL_DAC 0x0f

//defines which DAC channels are connected to which output
/*
throttle    left    right
            A        D
brake       left    right
            C        B
*/

#define throttleLeftDACChannel DAC_A
#define throttleRightDACChannel DAC_D
#define brakeLeftDACChannel DAC_C
#define brakeRightDACChannel DAC_B


#define Shift_Right(target,shift) (target>>shift)
#define Shift_Left(target,shift) (target<<shift)

#define extractor0_3   0xf000
#define extractor4_11  0x0ff0
#define extractor12_15 0x000f

#define DAC_mosi p11
#define DAC_sclk p13
#define DAC_miso p12
#define DAC_sync_pin p14
#define DAC_LDAC_pin p15
#define DAC_clear_pin p10

void writeToDAC(uint8_t target, int reading, uint8_t command);
char initDAC(void);
    
#endif