#include "DAC.h"

//Mbed pins setup of SPI
SPI DAC(DAC_mosi, DAC_miso, DAC_sclk); // mosi, miso, sclk
DigitalOut DAC_sync(DAC_sync_pin);
DigitalOut DAC_LDAC(DAC_LDAC_pin);
DigitalOut DAC_clear(DAC_clear_pin);

unsigned short word1 = 0, word2 = 0; 

void writeToDAC(uint8_t target, int reading, uint8_t command)
{ 
    // Select the device by seting chip select low
    DAC_sync = 0;
    
    /*
    byte1 = command;
    byte2 = (char)((target)+Shift_Right((reading&extractor0_3),12));
    byte3 = (char)(Shift_Right((reading&extractor4_11),4));
    byte4 = (char)(Shift_Left((reading&extractor12_15),4));
    */
    
    word1 = (command << 8) + (target << 4) + ( (reading & 0xf000) >> 12);
    word2 = ( (reading & 0x0fff) << 4);
    
    wait_us(40);
    DAC.write(word1);
    DAC.write(word2);
    
    //printf(" The sent 32 bits are %u %u \n", word1, word2);
    
    //Deselect the device
    DAC_sync = 1;
}

char initDAC(void)
{
    DAC.format(16,0);
    DAC.frequency(1000000);    // in HZ
    DAC_sync=1;
    DAC_LDAC=0;
    DAC_clear=1;
    return 0;
}  