#include "mbed.h"
#include "FXOS8700Q.h"
 //serial I/O
Serial bluetooth(PTC15,PTC14);    // ptc15: TX, ptc14: RX (frdmk64f)
Serial pc(USBTX, USBRX);

int data;

// Motor A connections
DigitalOut enA(PTC4);
DigitalOut in1(PTC2);
DigitalOut in2(PTC3);

// Motor B connections
DigitalOut enB(PTA1);
DigitalOut in3(PTC4);
DigitalOut in4(PTC12);

int main()
{
  
  bluetooth.baud(9600); // Default communication rate of the Bluetooth module
  pc.baud(9600);
  // Turn off motors - Initial state
    in1=0;
    in2=0;
    in3=0;
    in4=0;
               
    
  while(1) 
  {
            data=bluetooth.getc();
            bluetooth.printf("'%d' is recieved.\r\n",data);
            pc.printf("'%d' is recieved.\r\n",data);
    
 
    // Controlling the Motors
    if (data == 70) 
    { 
        // Turn on motor A & B for forward motion
        in1=1;
        in2=0;
        in3=1;
        in4=0;
        wait(0.2);
    }
    else if (data== 66) 
    { 
        // Turn on motor A & B in reverse direction
        in1=0;
        in2=1;
        in3=0;
        in4=1;
        wait(0.2);
    }
    else if (data== 76) 
    { 
        // Turn on motor B for left turn
        in1=0;
        in2=0;
        in3=1;
        in4=0;
        wait(0.2);
    }
    else if (data == 82) 
    { 
        // Turn on motor A for right turn
        in1=1;
        in2=0;
        in3=0;
        in4=0;
        wait(0.2);
    }
    else if (data == 83) 
    { 
        // Turn off motor A & B to stop
        in1=0;
        in2=0;
        in3=0;
        in4=0;
        wait(0.2);
    }
  }
}
