/*
This software is for BT_Car
-recieves data from android phone via bluetooth
-controls the car by using that data
*/

#include "mbed.h"

//serial I/O
Serial bluetooth(PTC15,PTC14);    // ptc15: TX, ptc14: RX (frdmk64f)
Serial pc(USBTX, USBRX);

int data;

// Motor A connections
DigitalOut enA(PTC4);
DigitalOut in1(PTC2);
DigitalOut in2(PTC3);

// Motor B connections
DigitalOut enB(PTA1);
DigitalOut in3(PTA4);
DigitalOut in4(PTB12);

int main()
{
  
  bluetooth.baud(9600); // Default communication rate of the Bluetooth module
  pc.baud(9600);
  // Turn off motors - Initial state
    in1=0;
    in2=0;
    in3=0;
    in4=0;
               
    
  while(1) 
  {
            data=bluetooth.getc();
            pc.printf("'%d' is recieved.\r\n",data);
    
 
    // Controlling the Motors
    if (data == 1) 
    { 
        // Turn on motor A & B
        in1=1;
        in2=0;
        in3=1;
        in4=0;
        wait(0.2);
    }
    else if (data== 2) 
    { 
        // Turn on motor A & B in reverse direction
        in1=0;
        in2=1;
        in3=0;
        in4=1;
        wait(0.2);
    }
    else if (data== 3) 
    { 
        // Turn on motor B
        in1=0;
        in2=0;
        in3=1;
        in4=0;
        wait(0.2);
    }
    else if (data == 4) 
    { 
        // Turn on motor A 
        in1=1;
        in2=0;
        in3=0;
        in4=0;
        wait(0.2);
    }
    else if (data == 0) 
    { 
        // Turn off motor A & B
        in1=0;
        in2=0;
        in3=0;
        in4=0;
        wait(0.2);
    }
  }
}
