#include "mbed.h" 
#include "DHT.h"
#include "ESP8266.h"               // Include header file from Author: Antonio Quevedo
#include "math.h"
#include <string>


#define APIKEY 9QSZ6SX8FLBFM640    //Put "Write key" of your channel in thingspeak.com 
#define IP "184.106.153.149"       // IP Address of "api.thingspeak.com\"
#define WIFI_SSID "Repulsive"
#define WIFI_PASS "319nwest425"

Serial pc(USBTX,USBRX);

ESP8266 esp(PTC17, PTC16, 115200); // baud rate for wifi

char snd[255],rcv[1000],snd_Data[255];           //snd= string used to send command to ESP 8266 wii and  rcv = string used to receive response from ESP8266 wifi module 

void esp_initialize(void); // Function used to initialize ESP8266 wifi module 
void esp_send(void);       // Function used to connect with thingspeak.com and update channel using ESP8266 wifi module 

//test variable 
float i=0;
float j=10;
float moisture_value = 0.0f; 
float light_value = 0.0f;
float h = 0.0f, c = 0.0f;


AnalogIn moisture(A0); 
AnalogIn light(A1);
DHT sensor(D3, DHT11);
DigitalOut LED(LED1);

// Motor A connections 
DigitalOut enA(PTC4);
DigitalOut in1(PTC2);
DigitalOut in2(PTC3);

// Motor B connections (Pump)
DigitalOut enB(PTA1);
DigitalOut in3(PTC4);
DigitalOut in4(PTC12);

int main() 
{
    pc.baud(115200);
    int error=0;
     // Turn off motors - Initial state
    in1=0;
    in2=0;
    in3=0;
    in4=0;
    
    esp_initialize();    
    
    while(1) 
    {
        wait(5.0f);     
        moisture_value = moisture;
        light_value = light.read();
        error = sensor.readData();
        
        if (0 == error) 
        {
            c   = sensor.ReadTemperature(CELCIUS);
            h   = sensor.ReadHumidity();
            printf("\n\rTemperature in Celcius: %4.2f \n",c);
            printf("\rHumidity is %4.2f\n", h);
        } 
        else 
        {
            printf("Error: %d\n", error);
        }
    
     printf("\rMoisture reading is %2.2f\n", moisture_value);
     printf("\rLight reading is %2.2f\n", light_value);
     
     if(c>29.00f)
     {
         in1= 0;
         in2= 1;
         printf("\rFan is ON\n");
     }
     else
     {
         in1=0;
         in2=0;
         printf("\rFan is OFF\n");
     }
     if(moisture_value<0.40f)
     {
         in3=1;
         in4=0;
         printf("\rPump is ON\n");
     }
     else
     {
         in3=0;
         in4=0;
         printf("\rPump is OFF\n");
     }
     
     if(light_value<0.30f)
     {
         LED = 0; //led on
         pc.printf("\rLights ON\n");
     }
    else{ 
        LED = 1; // led off
        pc.printf("\rLights OFF\n");
    }
     wait(1.0f); 
     esp_send();
    } 
}

void esp_initialize(void)
{    
    pc.printf("Initializing ESP\r\n"); 
      
    pc.printf("Reset ESP\r\n"); 
    esp.Reset();                   //RESET ESP
    esp.RcvReply(rcv, 400);        //receive a response from ESP
    //pc.printf(rcv);          //Print the response onscreen 
    wait(2);
    
    strcpy(snd,"AT");
    esp.SendCMD(snd);
    pc.printf(snd);
    //wait(2);
    esp.RcvReply(rcv, 400);       
    pc.printf(rcv);      
    wait(0.1);
    
    strcpy(snd,"AT+CWMODE=1");
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(2);
 
    strcpy(snd,"AT+CWJAP=\"");
    strcat(snd,WIFI_SSID);
    strcat(snd,"\",\"");
    strcat(snd,WIFI_PASS);
    strcat(snd,"\"");
    
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(5);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 
    
    strcpy(snd,"AT+CIPMUX=0");
    esp.SendCMD(snd);
    pc.printf(snd);
    //wait(2);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 
 
}
 
 
void esp_send(void)
{
   float field1 = c;
   float field2 = h;
   float field3 = moisture_value;
   float field4 = light_value;
    //ESP updates the Status of Thingspeak channel//
    
    strcpy(snd,"AT+CIPSTART=");
    strcat(snd,"\"TCP\",\"");
    strcat(snd,IP);
    strcat(snd,"\",80");
    
    esp.SendCMD(snd); 
    pc.printf("\rS\n%s",snd);
    //wait(2);                                                    
    esp.RcvReply(rcv, 1000);
    pc.printf("\rR\n%s",rcv);
    wait(1);
    
    sprintf(snd,"GET https://api.thingspeak.com/update?key=9QSZ6SX8FLBFM640&field1=%4.2f&field2=%4.2f&field3=%2.2f&field4=%2.2f\r\n",field1,field2,field3,field4);
    
    int i=0;
    for(i=0;snd[i]!='\0';i++);
    i++;
    char cmd[255];
    
    sprintf(cmd,"AT+CIPSEND=%d",i);                                       //Send Number of open connection and Characters to send 
    esp.SendCMD(cmd);
    pc.printf("\rS\n%s",cmd);
    while(i<=20 || rcv == ">")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("\rR\n%s",rcv);
    
    esp.SendCMD(snd);                                                      //Post value to thingspeak channel
    pc.printf("\rS\n%s",snd);
    
    while(i<=20 || rcv == "OK")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("\rR\n%s",rcv);
    
}