//SPI spi(PTE1, PTE3, PTE2);      // MOSI,MISO, CLOCK microcontroller(in order)     
//DigitalOut cs_sd(PTE22);

//Serial sd1(USBTX,USBRX);


#define SD_COMMAND_TIMEOUT 5000

#define SD_DBG             0

#define R1_IDLE_STATE           (1 << 0)
#define R1_ERASE_RESET          (1 << 1)
#define R1_ILLEGAL_COMMAND      (1 << 2)
#define R1_COM_CRC_ERROR        (1 << 3)
#define R1_ERASE_SEQUENCE_ERROR (1 << 4)
#define R1_ADDRESS_ERROR        (1 << 5)
#define R1_PARAMETER_ERROR      (1 << 6)



#define SD_MAX_CYCLES 10000

extern uint8_t SD_INIT_FLAGS;



int initialise_card();
int initialise_card_v1();
int initialise_card_v2();
int disk_write(const uint8_t *, uint64_t);
int disk_read(uint8_t *, uint64_t);
int disk_initialize();
int disk_erase(int,int);

//void FCTN_CDMS_INIT_SD();
//int FCTN_CDMS_WR_SD(const uint8_t *, uint64_t);
//int FCTN_CDMS_RD_SD(uint8_t *, uint64_t);
uint32_t FCTN_SD_MNGR(uint8_t);


int cmd(int, int);
int cmd58();
int cmdx(int, int);
int cmd8();
int read(uint8_t*, uint32_t );
int write(const uint8_t*, uint32_t );
static uint32_t ext_bits(unsigned char *, int , int );
int SD_WRITE(uint8_t*,uint32_t,uint8_t);
void FCTN_CDMS_SD_INIT();
int SD_READ(uint8_t*,uint32_t,uint8_t);
#define SDCARD_FAIL 0
#define SDCARD_V1   1
#define SDCARD_V2   2
#define SDCARD_V2HC 3











int cdv;
uint64_t sd_sectors();
uint64_t sectors;

void FCTN_CDMS_SD_INIT()
{
   
    initialise_card();
    
    disk_initialize();
         
}

    

uint32_t  FCTN_SD_MNGR(uint8_t sid)

{
   
    uint32_t SD_MNG_SECT=7000;
    
    uint32_t fsc;
    uint8_t buffer[512];
    int b=disk_read(buffer, SD_MNG_SECT);
    if(sid==0x0)
    {
        
        fsc=(uint32_t)(buffer[0]<<24)+(uint32_t)(buffer[1]<<16)+(uint32_t)(buffer[2]<<8)+(uint32_t)buffer[3];
        uint32_t next_fsc=fsc+1;
        buffer[0]=(uint8_t) (next_fsc>>24 & 0xFF);
        buffer[1]=(uint8_t) (next_fsc>>16 & 0xFF);
        buffer[2]=(uint8_t) (next_fsc>>8 & 0xFF);
        buffer[3]=(uint8_t) (next_fsc & 0xFF);
        buffer[511]+=2;
        disk_write(buffer,SD_MNG_SECT);
    }
    if(sid==0x1)
    {
        fsc=(uint32_t)(buffer[4]<<24)+(uint32_t)(buffer[5]<<16)+(uint32_t)(buffer[6]<<8)+(uint32_t)buffer[7];
        uint32_t next_fsc=fsc+1;
        buffer[4]=(uint8_t) (next_fsc>>24 & 0xFF);
        buffer[5]=(uint8_t) (next_fsc>>16 & 0xFF);
        buffer[6]=(uint8_t) (next_fsc>>8 & 0xFF);
        buffer[7]=(uint8_t) (next_fsc & 0xFF);
        buffer[511]+=2;
        disk_write(buffer,SD_MNG_SECT);
    }
    if(sid==0x2)
    {
        fsc=(uint32_t)(buffer[8]<<24)+(uint32_t)(buffer[9]<<16)+(uint32_t)(buffer[10]<<8)+(uint32_t)buffer[11];
        uint32_t next_fsc=fsc+1;
        buffer[8]=(uint8_t) (next_fsc>>24 & 0xFF);
        buffer[9]=(uint8_t) (next_fsc>>16 & 0xFF);
        buffer[10]=(uint8_t) (next_fsc>>8 & 0xFF);
        buffer[11]=(uint8_t) (next_fsc & 0xFF);
        buffer[511]+=2;
        disk_write(buffer,SD_MNG_SECT);
    }
     if(sid==0x3)
    {
        fsc=(uint32_t)(buffer[12]<<24)+(uint32_t)(buffer[13]<<16)+(uint32_t)(buffer[14]<<8)+(uint32_t)buffer[15];
        uint32_t next_fsc=fsc+1;
        buffer[12]=(uint8_t) (next_fsc>>24 & 0xFF);
        buffer[13]=(uint8_t) (next_fsc>>16 & 0xFF);
        buffer[14]=(uint8_t) (next_fsc>>8 & 0xFF);
        buffer[15]=(uint8_t) (next_fsc & 0xFF);
        buffer[511]+=2;
        disk_write(buffer,SD_MNG_SECT);
    }
     if(sid==0x4)
    {
        fsc=(uint32_t)(buffer[16]<<24)+(uint32_t)(buffer[17]<<16)+(uint32_t)(buffer[18]<<8)+(uint32_t)buffer[19];
        uint32_t next_fsc=fsc+1;
        buffer[16]=(uint8_t) (next_fsc>>24 & 0xFF);
        buffer[17]=(uint8_t) (next_fsc>>16 & 0xFF);
        buffer[18]=(uint8_t) (next_fsc>>8 & 0xFF);
        buffer[19]=(uint8_t) (next_fsc & 0xFF);
        buffer[511]+=2;
        disk_write(buffer,SD_MNG_SECT);
    }
    return fsc;
}


int SD_WRITE(uint8_t* buffer,uint32_t fsc,uint8_t sid)
{
   
    uint32_t SD_SCP_FIRST=1001;
    uint32_t SD_SCP_LAST=2000;
    uint32_t SD_SFF_AT_FIRST=2001;
    uint32_t SD_SFF_AT_LAST = 3000;
    uint32_t SD_SFF_BT_FIRST =3001;
    uint32_t SD_SFF_BT_LAST=4000;
    uint32_t SD_HK_ARCH_FIRST=4001;
    uint32_t SD_HK_ARCH_LAST= 5000;
    uint32_t LOG_FIRST =5001;
    uint32_t LOG_LAST=6000;
    uint32_t SD_MNG_SECT=7000;
    uint32_t block_number;
    int result;
    if(sid==0x0)
    {
        block_number=SD_SCP_FIRST+fsc;
//        printf("write_block_number=%d\r\n",block_number);
        result= disk_write(buffer,block_number);
        return result;
    }
   if(sid==0x1)
    {
        block_number=SD_SFF_AT_FIRST + fsc;
        result= disk_write(buffer,block_number);
        return result;
    }
     if(sid==0x2)
    {
        block_number=SD_SFF_BT_FIRST + fsc;
        result= disk_write(buffer,block_number);
        return result;
    }
     if(sid==0x3)
    {
        block_number=SD_HK_ARCH_FIRST+fsc;
//        sd1.printf("Block number is %d \r\n",block_number);
        result= disk_write(buffer,block_number);
        return result;
    }
     if(sid==0x4)
    {
        block_number=LOG_FIRST +fsc;
        result= disk_write(buffer,block_number);
        return result;
    }
    return 1;
}

int SD_READ(uint8_t* buffer,uint32_t fsc,uint8_t sid)
{
   
    uint32_t SD_SCP_FIRST=1001;
    uint32_t SD_SCP_LAST=2000;
    uint32_t SD_SFF_AT_FIRST=2001;
    uint32_t SD_SFF_AT_LAST = 3000;
    uint32_t SD_SFF_BT_FIRST =3001;
    uint32_t SD_SFF_BT_LAST=4000;
    uint32_t SD_HK_ARCH_FIRST=4001;
    uint32_t SD_HK_ARCH_LAST= 5000;
    uint32_t LOG_FIRST =5001;
    uint32_t LOG_LAST=6000;
    uint32_t SD_MNG_SECT=7000;
    uint32_t block_number;
    int result;
    if(sid==0x0)
    {
        block_number=SD_SCP_FIRST + fsc;
//        sd1.printf("read_block_number=%d\r\n",block_number);
        result= disk_read(buffer,block_number);
    }
   else if(sid==0x1)
    {
        block_number=SD_SFF_AT_FIRST + fsc;
        result= disk_read(buffer,block_number);
    }
    else if(sid==0x2)
    {
        block_number=SD_SFF_BT_FIRST + fsc;
        result= disk_read(buffer,block_number);
    }
    else if(sid==0x3)
    {
        block_number=SD_HK_ARCH_FIRST + fsc;
        result= disk_read(buffer,block_number);
    }
    else if(sid==0x4)
    {
        block_number=LOG_FIRST +fsc;
        result= disk_read(buffer,block_number);
    }
    else
    {
        return 1;
    }
    return result;
}


int initialise_card()
{
    // Set to 100kHz for initialisation, and clock card with cs_sd = 1
    spi.frequency(100000);           // changed on 31 12 2015 to 1 MHz 
    cs_sd = 1;
    for (int i = 0; i < 16; i++) {
        spi.write(0xFF);
    }

    // send CMD0, should return with all zeros except IDLE STATE set (bit 0)
    if (cmd(0, 0) != R1_IDLE_STATE) {
        debug("No disk, or could not put SD card in to spi idle state\r\n");
        return SDCARD_FAIL;
    }

// send CMD8 to determine whther it is ver 2.x
    int r = cmd8();
    if (r == R1_IDLE_STATE) {
//        printf("\rEntering v2\r\n");
        return initialise_card_v2();

    } else if (r == (R1_IDLE_STATE | R1_ILLEGAL_COMMAND)) {
//        printf("\rEntering v1\r\n");
        return initialise_card_v1();

    } else {
        debug("\rNot in idle state after sending CMD8 (not an SD card?)\r\n");
        return SDCARD_FAIL;
    }
}

int initialise_card_v1()
{
    for (int i = 0; i < SD_COMMAND_TIMEOUT; i++) {
        cmd(55, 0);
        if (cmd(41, 0) == 0) {
            gPC.puts("\rv1 initialization successfull\r\n");
            cdv = 512;
            debug_if(SD_DBG, "\n\rInit: SEDCARD_V1\n\r");

            return SDCARD_V1;
        }
    }

    debug("\rTimeout waiting for v1.x card\r\n");
    return SDCARD_FAIL;
}


int initialise_card_v2()
{
    for (int i = 0; i < SD_COMMAND_TIMEOUT; i++) {
        wait_ms(50);
        cmd58();
        cmd(55, 0);
        if (cmd(41, 0x40000000) == 0) {
            #if DEBUG
            gPC.puts("\rv2 initialization successfull\r\n");
            #endif
            cmd58();
            debug_if(SD_DBG, "\n\rInit: SDCARD_V2\n\r");
            cdv = 1;

            return SDCARD_V2;
        }
    }

    debug("\rTimeout waiting for v2.x card\r\n");
    return SDCARD_FAIL;
}

int cmd(int cmd, int arg)
{
    cs_sd = 0;

    // send a command
    spi.write(0x40 | cmd);
    spi.write(arg >> 24);
    spi.write(arg >> 16);
    spi.write(arg >> 8);
    spi.write(arg >> 0);
    spi.write(0x95);

    // wait for the repsonse (response[7] == 0)
    for (int i = 0; i < SD_COMMAND_TIMEOUT; i++) {
        int response = spi.write(0xFF);
        if (!(response & 0x80)) {
            cs_sd = 1;
            spi.write(0xFF);
            return response;
        }
    }
    cs_sd = 1;
    spi.write(0xFF);
    return -1; // timeout
}


int cmd58()
{
    cs_sd = 0;
    int arg = 0;

    // send a command
    spi.write(0x40 | 58);
    spi.write(arg >> 24);
    spi.write(arg >> 16);
    spi.write(arg >> 8);
    spi.write(arg >> 0);
    spi.write(0x95);

    // wait for the repsonse (response[7] == 0)
    for (int i = 0; i < SD_COMMAND_TIMEOUT; i++) {
        int response = spi.write(0xFF);
        if (!(response & 0x80)) {
            int ocr = spi.write(0xFF) << 24;
            ocr |= spi.write(0xFF) << 16;
            ocr |= spi.write(0xFF) << 8;
            ocr |= spi.write(0xFF) << 0;
            cs_sd = 1;
            spi.write(0xFF);
            return response;
        }
    }
    cs_sd = 1;
    spi.write(0xFF);
    return -1; // timeout
}


int cmd8()
{
    cs_sd = 0;

    // send a command
    spi.write(0x40 | 8); // CMD8
    spi.write(0x00);     // reserved
    spi.write(0x00);     // reserved
    spi.write(0x01);     // 3.3v
    spi.write(0xAA);     // check pattern
    spi.write(0x87);     // crc

    // wait for the repsonse (response[7] == 0)
    for (int i = 0; i < SD_COMMAND_TIMEOUT * 1000; i++) {
        char response[5];
        response[0] = spi.write(0xFF);
        if (!(response[0] & 0x80)) {
            for (int j = 1; j < 5; j++) {
                response[i] = spi.write(0xFF);
            }
            cs_sd = 1;
            spi.write(0xFF);
            return response[0];
        }
    }
    cs_sd = 1;
    spi.write(0xFF);
    return -1; // timeout
}

uint64_t sd_sectors()
{
    uint32_t c_size, c_size_mult, read_bl_len;
    uint32_t block_len, mult, blocknr, capacity;
    uint32_t hc_c_size;
    uint64_t blocks;

    // CMD9, Response R2 (R1 byte + 16-byte block read)
    if (cmdx(9, 0) != 0) {
        debug("\rDidn't get a response from the disk\n");
        return 0;
    }

    uint8_t cs_sdd[16];
    if (read(cs_sdd, 16) != 0) {
        debug("\rCouldn't read cs_sdd response from disk\n");
        return 0;
    }

    // cs_sdd_structure : cs_sdd[127:126]
    // c_size        : cs_sdd[73:62]
    // c_size_mult   : cs_sdd[49:47]
    // read_bl_len   : cs_sdd[83:80] - the *maximum* read block length

    int cs_sdd_structure = ext_bits(cs_sdd, 127, 126);

    switch (cs_sdd_structure) {
        case 0:
            cdv = 512;
            c_size = ext_bits(cs_sdd, 73, 62);
            c_size_mult = ext_bits(cs_sdd, 49, 47);
            read_bl_len = ext_bits(cs_sdd, 83, 80);

            block_len = 1 << read_bl_len;
            mult = 1 << (c_size_mult + 2);
            blocknr = (c_size + 1) * mult;
            capacity = blocknr * block_len;
            blocks = capacity / 512;
            debug_if(SD_DBG, "\n\rSDCard\n\rc_size: %d \n\rcapacity: %ld \n\rsectors: %lld\n\r", c_size, capacity, blocks);
            break;

        case 1:
            cdv = 1;
            hc_c_size = ext_bits(cs_sdd, 63, 48);
            blocks = (hc_c_size+1)*1024;
            debug_if(SD_DBG, "\n\rSDHC Card \n\rhc_c_size: %d\n\rcapacity: %lld \n\rsectors: %lld\n\r", hc_c_size, blocks*512, blocks);
            break;

        default:
            debug("cs_sdD struct unsupported\r\n");
            return 0;
    };
    return blocks;
}

int cmdx(int cmd, int arg)
{
    cs_sd = 0;

    // send a command
    spi.write(0x40 | cmd);
    spi.write(arg >> 24);
    spi.write(arg >> 16);
    spi.write(arg >> 8);
    spi.write(arg >> 0);
    spi.write(0x95);

    // wait for the repsonse (response[7] == 0)
    for (int i = 0; i < SD_COMMAND_TIMEOUT; i++) {
        int response = spi.write(0xFF);
        if (!(response & 0x80)) {
            return response;
        }
    }
    cs_sd = 1;
    spi.write(0xFF);
    return -1; // timeout
}

static uint32_t ext_bits(unsigned char *data, int msb, int lsb)
{
    uint32_t bits = 0;
    uint32_t size = 1 + msb - lsb;
    for (int i = 0; i < size; i++) {
        uint32_t position = lsb + i;
        uint32_t byte = 15 - (position >> 3);
        uint32_t bit = position & 0x7;
        uint32_t value = (data[byte] >> bit) & 1;
        bits |= value << i;
    }
    return bits;
}

int disk_initialize()
{
    int i = initialise_card();
    debug_if(SD_DBG, "init card = %d\n", i);
    sectors = sd_sectors();

    // Set block length to 512 (CMD16)
    if (cmd(16, 512) != 0) {
        debug("\rSet 512-byte block timed out\r\n");
        return 1;
    } else {    printf("\rDisk initialization successfull\r\n");
    }

    spi.frequency(1000000); // Set to 1MHz for data transfer
    return 0;
}

int disk_write(const uint8_t *buffer, uint64_t block_number)

{
    // set write address for single block (CMD24)
    if (cmd(24, block_number * cdv) != 0) {
        return 1;
    }

    // send the data block
    write(buffer, 512);
    //printf("Written Successfully bro \n");
    return 0;
}

int write(const uint8_t*buffer, uint32_t length)
{
    cs_sd = 0;

    // indicate start of block
    spi.write(0xFE);

    // write the data
    for (int i = 0; i < length; i++) {
        spi.write(buffer[i]);
    }

    // write the checksum
    spi.write(0xFF);
    spi.write(0xFF);

    // check the response token
    if ((spi.write(0xFF) & 0x1F) != 0x05) {
        cs_sd = 1;
        spi.write(0xFF);
        return 1;
    }

    // wait for write to finish
    while (spi.write(0xFF) == 0);

    cs_sd = 1;
    spi.write(0xFF);
    return 0;
}

int disk_read(uint8_t *buffer, uint64_t block_number)
{
    // set read address for single block (CMD17)
    if (cmd(17, block_number * cdv) != 0) {
        return 1;
    }

    // receive the data
    read(buffer, 512);
    return 0;
}

int read(uint8_t *buffer, uint32_t length)
{
    cs_sd = 0;

    // read until start byte (0xFF)
    while (spi.write(0xFF) != 0xFE);

    // read data
    for (int i = 0; i < length; i++) {
        buffer[i] = spi.write(0xFF);
    }
    spi.write(0xFF); // checksum
    spi.write(0xFF);

    cs_sd = 1;
    spi.write(0xFF);
    return 0;
}

int disk_erase(int startBlock, int totalBlocks)
{
    if(cmd(32, startBlock * cdv) != 0) {
        return 1;
    }
    if (cmd(33, (startBlock+totalBlocks-1) * cdv) != 0) {
        return 1;
    }
    if (cmd(38,0) != 0) {
        return 1;
    }
    
    return 0; //normal return
}