#include "ADXL345.h"
#include "mbed.h"
ADXL345 accelerometer(p5, p6, p7, p8);  //ADXL 345 Pins  SDA, SDO,SCL,CS
Serial pc(USBTX, USBRX); // ENABLING SERIAL COMMUNCIATION WITH PC
AnalogIn LM35(p15); // LM35 PIN
DigitalOut trigger(p9); // TRIG PIN OF ULTRASONIC SENSOR
DigitalOut aled(p11); //Accelerometer change indication led /Buzzer
DigitalOut tled(p12); //Temperature reading change indication led /Buzzer
DigitalOut oled(p13); //Obstacle detection indication led /Buzzer
DigitalIn  echo(p10);  //ECHO PIN OF ULTRASONIC SENSOR
DigitalIn safe(p14);  //Safety switch if the user, fallsdown the aled will turn on ,if the user is safe,he can press the safety switch so that aled will turn off
float dis = 0;  //VARAIBLE TO CALCULATE DISTANCE
int cf = 0;   // CORRECTION FACTOR FOR UNIT CONVERSION
Timer sonar;  // TIMER INITIALIZATION
int pxcut=100; //Mention your cut off Value in forward 
int nxcut=-100; //Mention your cut off Value in backward
int pycut=100; //Mention your cut off Value in left
int nycut=-100; //Mention your cut off Value in right
int main() {
    //---------Temperature sensor varaibles-------------//
    float tvalue;  //TEMPERATURE SENSOR VALUE READING
    //------------------Accelerometer sensor VARIABLES-----------//
    int readings[3] = {0, 0, 0};  //ACCELEROMETER 3-AXIS DATA
    accelerometer.setPowerControl(0x00); //ENABLLING THE STAND BY MODE
    accelerometer.setDataFormatControl(0x0B); //FULL RESOULTION, +/-16g, 4mg/LSB.
    accelerometer.setDataRate(ADXL345_3200HZ); //SETTING DATA TRANSFER RATE OF ADXL345 TO 3.2kHz
    accelerometer.setPowerControl(0x08); //Measurement mode.
    //---------------------Ultrasonics Sensor VARIABLES----------------------//
    sonar.reset(); //TIMER RESET
    sonar.start(); // TIMER START
    while (echo==2) {};
    sonar.stop();  //TIMER STOP
    cf = sonar.read_us(); // MICRO SECONDS CALCULATION
    
 
    while (1) {
    
        wait(0.1);
        
        accelerometer.getOutput(readings);
        
        //13-bit, sign extended values.
        pc.printf("%i, %i, %i\n", (int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2]);
        
        if ((int16_t)readings[0] > pxcut || (int16_t)readings[0] < nxcut ||(int16_t)readings[1] > pycut || (int16_t)readings[1] < nycut)
        {
            aled=1;
            wait(1);
            }
        tvalue = ((LM35.read()*3276)/10);
        if(tvalue >35)
        {
            tled=1;
            wait(1);
            }         
        pc.printf("Temp: %2.2f degree C\r\n", tvalue);
        wait(1);
        trigger = 1; // trigger sonar to send a ping
        sonar.reset();
        wait_us(10.0);
        trigger = 0;
        while (echo==0) {}; //wait for echo high
        sonar.start(); //echo high, so start timer
        while (echo==1) {}; //wait for echo low
        sonar.stop(); //stop timer and read value
        dis = (sonar.read_us()-cf)/58.0; //subtract software overhead timer delay and scale to cm
        pc.printf(" %d cm \n\r",dis);
        if(dis < 20 )
        {
            oled=1;
            wait(1);
            }
        wait(0.2);//wait so that any echo(s) return before sending another ping
        if (safe==1)
        {
            aled=0;
            wait(1);
            
            }
            aled=0;
            tled=0;
            oled=0;
    }
 
}