#include "hkfinal.h"

typedef struct SensorData {
    char Voltage[10];
    char Current[10];
    char Temperature[10];
    //float Battery[2];
}SensorDaty;

typedef struct ShortBeacon {
    char Voltage[1];
    char AngularSpeed[2];
    char SubsystemStatus[1]; 
    char Temp[3];  
    char ErrorFlag[1];
}ShortBeacy;

int quantiz(float start,float step,float x)
{
    int y=(x-start)/step;
    if(y<=0)y=0;
    if(y>=15)y=15;
    return y;
}

void init_beacon(ShortBeacy x){
    x.Voltage={1};
    x.AngularSpeed={2,3}
    x.SubsystemStatus={145};
    x.Temp={1,2,3};
    x.ErrorFlag={3};
}

void FUNC_HK_MAIN()
{
    SensorDaty SensorData;
    ShortBeacy ShortBeacon;
    init_beacon(ShortBeacon);

    int LoopIterator;

    SelectLine0=0;
    SelectLine1=0;
    SelectLine2=0;
    SelectLine3=0;

    for(LoopIterator=0; LoopIterator<16; LoopIterator++) {

        if(LoopIterator%2==0) {
            SensorData.Current[LoopIterator]=quantiz(cstart,cstep,(CurrentInput.read()/(50*rsens)));
            SensorData.Voltage[LoopIterator]=quantiz(vstart,vstep,(VoltageInput.read()/5.37));
            SensorData.Temperature[LoopIterator]=quantiz(tstart,tstep,(-90.7*3.18*TemperatureInput.read()+190.1543));
        } else {
            SensorData.Current[LoopIterator-1]=Current[LoopIterator-1]<<4+quantiz(cstart,cstep,(CurrentInput.read()/(50*rsens)));
            SensorData.Voltage[LoopIterator-1]=Voltage[LoopIterator-1]<<4+quantiz(vstart,vstep,(VoltageInput.read()/5.37));
            SensorData.Temperature[LoopIterator-1]=Temperature[LoopIterator-1]<<4+quantiz(tstart,tstep,(-90.7*3.18*TemperatureInput.read()+190.1543));
        }
// The following lines are used to iterate the select lines from 0 to 15
        SelectLine0=!(SelectLine0);

        if(LoopIterator%2==1)
            SelectLine1=!(SelectLine1);

        if(LoopIterator%4==3)
            SelectLine2=!(SelectLine2);

        if(LoopIterator%8==7)
            SelectLine3=!(SelectLine3);

        wait_us(10.0); //  A delay of 10 microseconds between each sensor output. Can be changed.

    }

}