#include "hktent.h"

DigitalOut SelectLine3 (p24); // MSB of Select Lines
DigitalOut SelectLine2 (p23);
DigitalOut SelectLine1 (p22);
DigitalOut SelectLine0 (p21); // LSB of Select Lines

AnalogIn CurrentInput(p15); // Input from Current Multiplexer
AnalogIn VoltageInput(p16); // Input from Voltage Multiplexer
AnalogIn TemperatureInput(p17); // input from Temperature Multiplexer

int quantiz(float start,float step,float x)
{
    int y=(x-start)/step;
    if(y<=0)y=0;
    if(y>=15)y=15;
    return y;
}
void init_shrtbeac(ShortBeacy ShortBeacon){
    ShortBeacon.Voltage[0]=1;
    ShortBeacon.AngularSpeed[0]=1;
    ShortBeacon.AngularSpeed[1]=2;
    ShortBeacon.SubsystemStatus[0]=145;
    ShortBeacon.Temp[0]=1;ShortBeacon.Temp[1]=1;ShortBeacon.Temp[2]=1;
    ShortBeacon.ErrorFlag[0]=2;
}

int main()
{
    init_shrtbeac(ShortBeacon);
    int LoopIterator;

    SelectLine0=0;
    SelectLine1=0;
    SelectLine2=0;
    SelectLine3=0;

    for(LoopIterator=0; LoopIterator<16; LoopIterator++) {

        if(LoopIterator%2==0) {
            SensorData.Current[LoopIterator/2]=quantiz(cstart,cstep,(CurrentInput.read()/(50*rsens)));
            SensorData.Voltage[LoopIterator/2]=quantiz(vstart,vstep,(VoltageInput.read()/5.37));
            SensorData.Temperature[LoopIterator/2]=quantiz(tstart,tstep,(-90.7*3.18*TemperatureInput.read()+190.1543));
        } else {
            SensorData.Current[(LoopIterator-1)/2]=SensorData.Current[LoopIterator-1]<<4+quantiz(cstart,cstep,(CurrentInput.read()/(50*rsens)));
            SensorData.Voltage[(LoopIterator-1)/2]=SensorData.Voltage[LoopIterator-1]<<4+quantiz(vstart,vstep,(VoltageInput.read()/5.37));
            SensorData.Temperature[(LoopIterator-1)/2]=SensorData.Temperature[LoopIterator-1]<<4+quantiz(tstart,tstep,(-90.7*3.18*TemperatureInput.read()+190.1543));
        }
// The following lines are used to iterate the select lines from 0 to 15
        SelectLine0=!(SelectLine0);

        if(LoopIterator%2==1)
            SelectLine1=!(SelectLine1);

        if(LoopIterator%4==3)
            SelectLine2=!(SelectLine2);

        if(LoopIterator%8==7)
            SelectLine3=!(SelectLine3);

        wait_us(10.0); //  A delay of 10 microseconds between each sensor output. Can be changed.

    }
return 1;
}