#include "mbed.h"

#define FORWARD 0
#define REVERSE 1

#define ON_OFF                    '0'
#define FRONT                     '1'
#define BACK                      '2'
#define LEFT                      '3'
#define RIGHT                     '4'
#define HALF_FRONT_RIGHT          '5'
#define HALF_FRONT_LEFT           '6'
#define HALF_BACK_RIGHT           '7'
#define HALF_BACK_LEFT            '8'

/********************H-Bridge pins*****************/
DigitalOut Ain1(p6);
DigitalOut Ain2(p5);
DigitalOut Bin1(p7);
DigitalOut Bin2(p8);
PwmOut motorA(p22);
PwmOut motorB(p23);

/********************X-Bee Configuration*****************/
Serial xbee(p9,p10);
DigitalOut rst(p11);

DigitalOut led1(LED1);
DigitalOut led2(LED2);

/*******************Motor directions***************/
void forward();
void reverse();
void left(float);
void right(float);
void stop();


void Move(char DirectionToMove, int& prevState);

float time_rotate = 0.5;

int main()
{
    rst = 0;
    wait(0.5);
    rst = 1;
    wait(0.5);

    int prevState = 1;  // 1 for forward and 0 for back    
    int onOff = 1;      // 1 for ON 0 for OFF
    char DirectionToMove = '1';
    
    /* init of prevhbridgestatus comes here*/
        
    while(1)
    {
          while(!(xbee.readable()))
          {
            led1 = 1;
          }
          led1 = 0;
          
          led2 = prevState;
          
          DirectionToMove = xbee.getc();
          
          if(DirectionToMove == '0')
          {
            if(onOff == 1)
            {
                onOff = 0;
                stop();
            }
            else
                onOff = 1;
          }
          else if(onOff == 1)
          {
            Move(DirectionToMove, prevState); /* This function moves along a direction determined by current direction and the previous direction of motion */
          }
    }                                                         

}

void Move(char DirectionToMove, int& prevState)
{
    switch(DirectionToMove)
    {
        case FRONT:
            forward();
            prevState = 1;
            break;       
                 
        case BACK:
            reverse();
            prevState = 0;
            break;         
               
        case LEFT:
            left(2 * time_rotate);            
            if(prevState == 0)
                reverse();
            else
                forward();
            break;
            
        case RIGHT:
            right(2 * time_rotate);
            if(prevState == 0)
                reverse();
            else
                forward();
            break;
            
        case HALF_FRONT_RIGHT:
            right(time_rotate);
            prevState = 1;
            forward();
            break;
            
        case HALF_FRONT_LEFT:
            left(time_rotate);
            prevState = 1;
            forward();
            break;
            
        case HALF_BACK_RIGHT:
            right(time_rotate);
            prevState = 0;
            reverse();
            break;
            
        case HALF_BACK_LEFT:
            left(time_rotate);
            prevState = 0;
            reverse();
            break;
            
        default:
            break;
    }
} 
           
void reverse()
{
    stop();
    Ain1 = 1;
    Ain2 = 0;
    Bin1 = 1;
    Bin2 = 0; 
    motorA = 0.5;       
    motorB=0.5; 
                            
}

void forward()
{
    stop();
    Ain1 = 0;
    Ain2 = 1;
    Bin1 = 0;
    Bin2 = 1; 
    motorA = 0.5;       
    motorB=0.5;
   
}
void left(float time1)
{
    stop();
    Ain1 = 1;
    Ain2 = 0;  
    Bin1 = 0;
    Bin2 = 1;  
    motorA = 0.5;       
    motorB=0.5;
    wait(time1);             
}
void right(float time1)
{
    stop();
    Ain1 = 0;
    Ain2 = 1;  
    Bin1 = 1;
    Bin2 = 0;  
    motorA = 0.5;       
    motorB=0.5;
    wait(time1);          
}

void stop()
{
       Ain1 = 0;
       Ain2 = 0; 
       Bin1 = 0;
       Bin2 = 0; 
       motorA = 1;  
       motorB=1;

}