/* Author: Pramod Nataraja & Vishnu Venkat  */
 
 #include "mbed.h" 
 #include "VS1002.h" 
 #include "TextLCD.h"
 #include "mpr121.h"
  
VS1002 mp3(p5, p6, p7, p8,"sd",p11, p12 ,p13, p14, p23, p22, p21, p15);  //Setup Audio decoder. Name is VS1002 even though VS1053 is used.
TextLCD lcd1(p30, p29, p17, p18, p19, p20); //setup lcd
InterruptIn interrupt(p26); // Create the interrupt receiver object on pin 26
I2C i2c(p9, p10); // Setup the i2c bus on pins 9 and 10
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS); //Setup Mpr121

/* Global Variables to store Status*/
int new_song_number=1;  //Variable to store the Song Number
int volume_set=-20;     //Variable to store the Volume
int previous_volume;    //Variable to store the volume when muted
bool pause=false;       //Variable to store the status of Pause button 
bool mute=false;        //Variable to store the status of mute button

int check=0;    //Capacitative touch generates interrupt on both press and release. This variable tracks this and updates only on press.
char *song_name[6]={"18 till I Die","Summer of 69","Boulevard", "Serenity","Crawling","In the end"}; //Array of song names entered manually

void fallInterrupt() 
{
  int key_code=0;
  int i=0;
  int value;
  value=mpr121.read(0x00);
  value +=mpr121.read(0x01)<<8;

   i=0;
  if(check)
    check=0;
   else
    check=1;
  if(check)
    {
  for (i=0; i<12; i++) {
  if (((value>>i)&0x01)==1) key_code=i+1; //Convert value into decimal
     }

 switch(key_code)  // Different cases depending on key press
 {
  case 0:break;  // Invalid entry . Valid 1-12
  case 1:   
  case 2:  
  case 3:  
  case 4:    
  case 5:     
  case 6: new_song_number=key_code; // Play the selected song
          break; 
  case 7:new_song_number+=1;  // Next song
          if(new_song_number==7)
           new_song_number=1;
          break;
  case 8: new_song_number-=1;  // Previous Song
          if(new_song_number==0)
           new_song_number=6;
          break;
  case 9: pause=!pause; // Pause/Play button
          break;
  case 10: volume_set+=3; // Volume Up
           if(volume_set>=0)
            volume_set=0;
           break;
  case 11: volume_set-=3;  //Volume Down
           if(volume_set<-55)
            volume_set=-55;
            break;
  case 12: mute=!mute;  //Mute/Unmute
           if(mute)
           {
            previous_volume=volume_set; // Attenuation of -55 db is small enough to not hear anything
            volume_set=-55;
           }
           else
           {
           volume_set=previous_volume;
           }
           break;
  default: lcd1.cls();
           lcd1.printf("error");  // exit on error
           exit(1);
        }
 }
 /* Print to LCD the status of Song */
  lcd1.cls();
  if(pause)
    lcd1.printf("Paused ");
  if(mute)
   lcd1.printf("Muted");
  if(!mute && !pause)
   lcd1.printf("Playing"); 
  lcd1.printf("\n %d %s",new_song_number,song_name[new_song_number-1]);
  
 }

 int main () 
 {       
     /*============================================================ 
      * MP3 Initialising 
      *==========================================================*/
      
     mp3._RST = 1; 
     mp3.cs_high();                                  //chip disabled 
     mp3.sci_initialise();                           //initialise MBED 
     mp3.sci_write(0x00,(SM_SDINEW+SM_STREAM+SM_DIFF)); 
     mp3.sci_write(0x03, 0x9800); 
     mp3.sdi_initialise();    
          
      
   /* Touch Pad setup */
      interrupt.fall(&fallInterrupt);
      interrupt.mode(PullUp);

         while(1)
         {
         mp3.play_song(new_song_number);
         }       
 
 } 
 
          
