/*
    Author:Pralish Satyal
    filename: class.cpp
    SPACE INVADERS PROJECT
*/

//----------------------INITIALISATION AND INCLUDING FILES-===----------------//
#include "mbed.h"
#include "N5110.h"
#include "Joystick.h"
#include "StrLib.h" 

N5110 lcd(p8,p9,p10,p11,p13,p21);
Joystick joystick(p20, p19, p17); 
AnalogIn  joy_x(p19);
AnalogIn  joy_y(p20);
InterruptIn buttonA(p29); 
InterruptIn buttonC(p27); 
BusOut rgb_led(p24,p23,p22);

//Global variables
volatile int g_buttonA_flag = 0;
volatile int g_buttonC_flag = 0;
volatile int g_game_end_flag = 0;
volatile int game_end_flag = 0;

//function prototype
void buttonA_isr();
void buttonC_isr();
void init_leds();
void initialise();
void player_death();
void about_game();


//Sprite Classes
const int playerSprite[6][10] = 
{
    { 0,0,0,0,1,1,0,0,0,0 },
    { 0,1,1,1,1,1,1,1,1,0 },
    { 1,1,1,1,1,1,1,1,1,1 },
    { 1,1,1,1,1,1,1,1,1,1 },
    { 1,1,1,1,1,1,1,1,1,1 },
    { 1,1,1,1,1,1,1,1,1,1 },
};

const int enemySprite[8][12] = 
{
    { 0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,0,0,1,1,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,1,1,0,1,1,0,0 },
    { 0,1,1,1,1,1,1,1,1,1,1,0 },
    { 0,1,0,1,1,1,1,1,1,0,1,0 },
    { 0,1,0,1,0,0,0,0,1,0,1,0 },
    { 0,0,0,0,1,1,1,1,0,0,0,0 },
};

const int EnemyDeathAnimation[10][8][12] = 
{
    {
    { 0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,0,0,1,1,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,1,1,0,1,1,0,0 },
    { 0,1,1,1,1,1,1,1,1,1,1,0 },
    { 0,1,0,1,1,1,1,1,1,0,1,0 },
    { 0,1,0,1,0,0,0,0,1,0,1,0 },
    { 0,0,0,0,1,1,1,1,0,0,0,0 },
    },
    {
    { 0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,0,0,1,1,1,1,1,1,0,0,0 },
    { 0,0,1,1,0,1,1,0,1,1,0,0 },
    { 0,1,1,1,1,1,1,1,1,1,1,0 },
    { 0,1,0,1,1,1,1,1,1,0,1,0 },
    { 0,1,0,1,0,0,0,0,1,0,1,0 },
    { 0,0,0,0,1,1,1,1,0,0,0,0 },
    },
    {
    { 0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,0,0,1,0,1,1,0,1,0,0,0 },
    { 0,0,1,1,0,1,1,0,1,1,0,0 },
    { 0,1,1,1,1,1,1,1,1,1,1,0 },
    { 0,1,0,1,1,1,1,1,1,0,1,0 },
    { 0,1,0,1,0,0,0,0,1,0,1,0 },
    { 0,0,0,0,1,1,1,1,0,0,0,0 },
    },
    {
    { 0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,0,0,1,0,1,1,0,1,0,0,0 },
    { 0,0,1,1,0,1,1,0,1,1,0,0 },
    { 0,1,1,0,0,1,1,0,0,1,1,0 },
    { 0,1,0,1,1,1,1,1,1,0,1,0 },
    { 0,1,0,1,0,0,0,0,1,0,1,0 },
    { 0,0,0,0,1,1,1,1,0,0,0,0 },
    },
    {
    { 0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,0,0,1,0,1,1,0,1,0,0,0 },
    { 0,0,1,1,0,0,0,0,1,1,0,0 },
    { 0,1,1,0,0,1,1,0,0,1,1,0 },
    { 0,1,0,0,1,0,0,1,0,0,1,0 },
    { 0,1,0,1,0,0,0,0,1,0,1,0 },
    { 0,0,0,0,1,1,1,1,0,0,0,0 },
    },
    {
    { 0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,0,0,1,0,1,1,0,1,0,0,0 },
    { 0,0,1,1,0,0,0,0,1,1,0,0 },
    { 0,1,0,0,0,1,1,0,0,1,1,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,1,0,1,0,0,0,0,1,0,1,0 },
    { 0,0,0,0,1,1,1,1,0,0,0,0 },
    },
    {
    { 0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,0,0,1,0,1,0,0,1,0,0,0 },
    { 0,0,1,0,0,0,0,0,0,1,0,0 },
    { 0,1,0,0,0,0,1,0,0,0,1,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,1,0,1,0,0,0,0,1,0,1,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    },
    {
    { 0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,1,0,0,0,0,0,0,1,0,0 },
    { 0,0,0,0,0,0,1,0,0,0,0,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,1,0,1,0,0,0,0,1,0,1,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0 },
    },
    {
    { 0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,1,0,0,0,0,1,0,0,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0 },
    { 0,0,0,0,0,0,1,0,0,0,0,0 },
    { 0,0,0,0,1,0,0,1,0,0,0,0 },
    { 0,1,0,0,0,0,0,0,0,0,1,0 },
    { 0,0,0,0,0,0,0,0,0,0,0,0 },
    }
};

const int shootSprite[3][4] = 
{
    {0,1,1,0},
    {0,1,1,0},
    {0,1,1,0},
};

//----------------------------FUNCTIONS---------------------------------------//
void player_death()
{
    //code to go within the if player has been shot logic
    //if player has been shot, print string saying 'GAME OVER'.
    lcd.printString("GAME OVER ", 0, 1);
    lcd.refresh();
    wait(4);
    
    //lcd.clear();
    
    lcd.printString("Play again?", 0, 2);
    lcd.refresh();
    wait(2);
    
    lcd.printString("Reset MBed", 0,3);
    lcd.refresh();
    wait(100);
}

void about_game()
{
    lcd.clear();
    
    lcd.printString("Shoot=A", 0 ,1);
    lcd.refresh();
    wait(1);
    
    lcd.printString("x,y =Joystick", 0,3);
    lcd.refresh();
    wait(1);
    
    lcd.printString("Red=Enemy shot", 0,4);
    lcd.refresh();
    wait(1);
    
    lcd.printString("Green=shot", 0,5);   
    lcd.refresh();
    wait(4);
}


//---------------------------PLAYER CLASS-------------------------------------//

class User 
{
    public:
        int x_pos, y_pos; //for player postion
        int lives; //haven't used this, currently just have one life
        
        User();//constructor
        //~User();//deconstructor
        
        //User functions
        void joystick_control();
        void drawplayer(N5110 &lcd);
};
    
User::User()
{
    x_pos = 0;
    y_pos = 40;
}

void User::joystick_control()
{
    float x_joy = joy_x.read();
    float y_joy = joy_y.read();
    
    if(joy_x<0.3)
    {
        //move to the left    
        x_pos+=4;    
    }
    else if (joy_x>0.7)
    {
        //move to the right
        x_pos-=4;
    }
    if(x_pos>84)
    {
        x_pos=0;
    }
    else if (x_pos<0)
    {
        x_pos=84;
    }
}
    
    
    
//----------------------------ENEMY CLASS-------------------------------------//
class Enemy
{
    public:
        //enemyVariables
        char direction;
        int enemy_x_pos;
        int enemy_y_pos;
        int enemy_death_flag;
        bool enemy_print_flag;
        bool hit_looker_flag;
        
        Enemy();
        
        //function methods
        void death_animation(int enemy_x, int enemy_y);
        void enemy_die(int enemy, Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4);
        void enemyMove(Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4);
};

//constructor method to initialise variables within Enemy Class
Enemy::Enemy()
{
    enemy_x_pos=0;
    enemy_y_pos=5;
    direction='r';
    enemy_death_flag=0;
    enemy_print_flag=true;
    hit_looker_flag=false;
}

//Enemy method for enemies movement across the screen
void Enemy::enemyMove(Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4)
{
    if (direction == 'r')
    {
        enemy1.enemy_x_pos +=2;
        enemy2.enemy_x_pos +=2;
        enemy3.enemy_x_pos +=2;
        enemy4.enemy_x_pos +=2;
    }
    else
    {
        enemy1.enemy_x_pos -=2;
        enemy2.enemy_x_pos -=2;
        enemy3.enemy_x_pos -=2;
        enemy4.enemy_x_pos -=2;  
    } 
    if (enemy1.enemy_x_pos <=0)
    {
            direction = 'r';
            enemy1.enemy_y_pos +=2;
            enemy2.enemy_y_pos +=2;
            enemy3.enemy_y_pos +=2;
            enemy4.enemy_y_pos +=2;
    }
        else if (enemy4.enemy_x_pos >= 70)
        {
            direction = 'l';
            enemy1.enemy_y_pos +=2;
            enemy2.enemy_y_pos +=2;
            enemy3.enemy_y_pos +=2;
            enemy4.enemy_y_pos +=2;
        }
    if((enemy1.enemy_y_pos>30)||(enemy2.enemy_y_pos>30)||(enemy3.enemy_y_pos>30)||(enemy4.enemy_y_pos>30))
    {
        //printf("End has been reached. \n");
        lcd.clear();
        lcd.printString("GAME OVER",0, 1);
        lcd.refresh();
        wait(1);
        lcd.printString("PLAY AGAIN?", 0,2);
        lcd.refresh();
        wait(1);
        
        lcd.printString("RESET MBED ",0,4);
        lcd.refresh();
        wait(100);
    }
}   

void Enemy::death_animation(int enemy_x, int enemy_y)
{
    for(int n=0; n<=10; n++)
    {
        lcd.drawSprite(enemy_x, enemy_y, 8, 12, (int*) EnemyDeathAnimation[n]);
        lcd.refresh();
    }
}

//Enemy method to call death animation depending on what enemy died
void Enemy::enemy_die(int enemy, Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4)
{
    switch(enemy)
    {
        case 1:
            enemy1.death_animation(enemy1.enemy_x_pos, enemy1.enemy_y_pos); //if enemy one dies, no longer print it to the screen
            enemy1.enemy_print_flag=false;
            enemy1.hit_looker_flag=false;
            //printf("Inside switch case 1");
            break;
        case 2:
            enemy2.death_animation(enemy2.enemy_x_pos, enemy2.enemy_y_pos);
            enemy2.enemy_print_flag=false;
            enemy2.hit_looker_flag=false;
            break;
        case 3:
            enemy3.death_animation(enemy3.enemy_x_pos, enemy3.enemy_y_pos);
            enemy3.enemy_print_flag=false;
            enemy3.hit_looker_flag=false;
            break;
        case 4:
            enemy4.death_animation(enemy4.enemy_x_pos, enemy4.enemy_y_pos);
            enemy4.enemy_print_flag=false;
            enemy4.hit_looker_flag=false;
            break;
    }
}



//---------------------------------SHOT CLASS---------------------------------//
class Shot
{
    public:
        bool shoot_flag; //flag for user shooting at enemy
        bool enemy_shoot_flag; //check if any bullets are active
        bool hit_looker_flag;
        
        int game_flag;
        int game_flag_end;
        int y;
        int x;
        int enemy_bullet_y;
        int enemy_bullet_x;
        int enemy_n;
        Shot();
        
        void shootshot(User &player); //function to shoot shot if you are the player shooting
        void collision(Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4); //function to detect collision from the shot to the enemy
        void shooting(); //function to shoot 
        void drawshot(N5110 &lcd);
        
        //function to create a enemy bullet
        void enemyshoot(Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4); //need to figure out
        void collisionForPlayer(User &player); //done
        void enemyShooting(); //fucntion for enemy to shoot (done)
        void drawEnemyShot(N5110 &lcd); //done 
};

//Constructor method for Shot Class to initialiise variables
Shot::Shot()
{
    shoot_flag=false;
    enemy_shoot_flag=false;
    game_flag=1;
    game_flag_end=0;
    y=0;  
    x=0;
    enemy_n=4;
    enemy_bullet_x=0;
    enemy_bullet_y=0;
}

//Shooting method for player
void Shot::shooting()
{   
    y -= 2;
    //printf("Y: %i \n", y);
}

//Shooting method for enemy
void Shot::enemyShooting()
{
    enemy_bullet_y+=3;   
}

//Collision Detection for Shot with enemy Sprite
void Shot::collision(Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4)
{
//if there has already been a shot, then don't check for collision again for this enemy
    //Detecting Collision with Enemy1
    if((x<enemy1.enemy_x_pos + 12) &&(x + 4 > enemy1.enemy_x_pos) &&(y<enemy1.enemy_y_pos +8)&&(y+3>enemy1.enemy_y_pos))
    {
        rgb_led.write(0b010);
        enemy1.enemy_die(1, enemy1, enemy2, enemy3, enemy4);
        shoot_flag=false;
        x=0;
        y=0;
        enemy_n--;
    }
    //Detecting Collision with Enemy2
    if((x<enemy2.enemy_x_pos + 12) &&(x + 4 > enemy2.enemy_x_pos) &&(y<enemy2.enemy_y_pos +8)&&(y+3>enemy2.enemy_y_pos))
    {
        rgb_led.write(0b010);
        enemy2.enemy_die(2, enemy1, enemy2, enemy3, enemy4);
        shoot_flag=false;
        x=0;
        y=0;
        enemy_n--;
    }
    //Detecting Collision with Enemy3
    if((x<enemy3.enemy_x_pos + 12) &&(x + 4 > enemy3.enemy_x_pos) &&(y<enemy3.enemy_y_pos +8)&&(y+3>enemy3.enemy_y_pos))
    {
        rgb_led.write(0b010);
        enemy3.enemy_die(3, enemy1, enemy2, enemy3, enemy4);
        shoot_flag=false;
        x=0;
        y=0;
        enemy_n--;
    }
    //Detecting Collision with Enemy4
    if((x<enemy4.enemy_x_pos + 12) &&(x + 4 > enemy4.enemy_x_pos) &&(y<enemy4.enemy_y_pos +8)&&(y+3>enemy4.enemy_y_pos))
    {
        rgb_led.write(0b010);
        enemy4.enemy_die(4, enemy1, enemy2, enemy3, enemy4);
        shoot_flag=false;
        enemy4.hit_looker_flag=false;
        x=0;
        y=0;
        enemy_n--;
    }
}

//Method detecting collision against the shot and the player
void Shot::collisionForPlayer(User &player)
{
    if(game_flag)
    {
        if((enemy_bullet_x<player.x_pos +10) &&(enemy_bullet_x + 4 > player.x_pos)&&(enemy_bullet_y<player.y_pos +6)&&(enemy_bullet_y+3>player.y_pos))
        {
            rgb_led.write(0b010);
            game_flag_end=1;
            if(game_flag_end==1){
                player_death();
            }
        }
    }
}

//Method for the Player to Shoot
void Shot::shootshot(User &player)
{
    if((buttonA.read()==1)&&y<0)
    {
        shoot_flag = true; //if you press buttonA, shoot provided there is not another bullet active
        x=player.x_pos;
        y=40;
        g_buttonA_flag = 0;
        rgb_led.write(5);
    }
    else
    {
        shoot_flag = false; //i.e. if the bullet is at 0, you don't want to shoot
        init_leds(); 
    }
}

//Method for the Enemy to Shoot
void Shot::enemyshoot(Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4)
{
    //check if a shots already active
    if(enemy_bullet_y>40)
    {
        int enemy = rand()%enemy_n;
        switch(enemy)
        {
            case 0:
                enemy_bullet_x=enemy1.enemy_x_pos;
                enemy_bullet_y=enemy1.enemy_y_pos;
                break;
            case 1:
                enemy_bullet_x=enemy2.enemy_x_pos;
                enemy_bullet_y=enemy2.enemy_y_pos;
                break;
            case 2:
                enemy_bullet_x=enemy3.enemy_x_pos;
                enemy_bullet_y=enemy3.enemy_y_pos;
                break;
            case 3:
                enemy_bullet_x=enemy4.enemy_x_pos;
                enemy_bullet_y=enemy4.enemy_y_pos;
                break;
    } 
    }
}



//---------------------------------GAME ENGINE--------------------------------//
class Gameplay
{
    public:
        int game_flag_end;
        int game_loops;
        int updates;
        
        Gameplay();
        
        //Methods
        //initialisation of the buttons and int main stuff
        void game_init(User &player, Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4); 
        //Infinite game loop   
        void game_loop(User &player, Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4, Shot &shot, N5110 &lcd); 
};

Gameplay::Gameplay()
{    
    game_loops=0;
    updates=0;
}

void Gameplay::game_init(User &player, Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4)
{ 
    buttonA.rise(&buttonA_isr);
    buttonA.mode(PullNone);
    buttonC.rise(&buttonC_isr);
    buttonC.mode(PullNone);
    
    enemy1.enemy_x_pos=0;
    enemy2.enemy_x_pos=15;
    enemy3.enemy_x_pos=30;
    enemy4.enemy_x_pos=45;
    
    enemy1.enemy_y_pos=5;
    enemy2.enemy_y_pos=5;
    enemy3.enemy_y_pos=5;
    enemy4.enemy_y_pos=5;
}

void Gameplay::game_loop(User &player, Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4, Shot &shot, N5110 &lcd)
{
        player.drawplayer(lcd);
        player.joystick_control();

        shot.shootshot(player);
        shot.collision(enemy1, enemy2, enemy3, enemy4);
        shot.shooting();
        shot.drawshot(lcd);
        

        shot.enemyShooting(); 
        shot.drawEnemyShot(lcd);
        shot.collisionForPlayer(player); //within collision detection between shot and player, we can see/call the function that prints to screen     
}



//---------------------------DRAWING------------------------------------------//
void User::drawplayer(N5110 &lcd)
{
    lcd.drawSprite(x_pos,y_pos,6,10,(int *)playerSprite);
}
 void drawEnemy1(N5110 &lcd, Enemy &enemy1)
{
    lcd.drawSprite(enemy1.enemy_x_pos, enemy1.enemy_y_pos, 8, 12, (int *)enemySprite);
}      
 void drawEnemy2(N5110 &lcd, Enemy &enemy2)
{
    lcd.drawSprite(enemy2.enemy_x_pos, enemy2.enemy_y_pos, 8, 12, (int *)enemySprite);
}  
 void drawEnemy3(N5110 &lcd, Enemy &enemy3)
{
    lcd.drawSprite(enemy3.enemy_x_pos, enemy3.enemy_y_pos, 8, 12, (int *)enemySprite);
}  
 void drawEnemy4(N5110 &lcd, Enemy &enemy4)
{
    lcd.drawSprite(enemy4.enemy_x_pos, enemy4.enemy_y_pos, 8, 12, (int *)enemySprite);
}  
void Shot::drawEnemyShot(N5110 &lcd)
{   
    lcd.drawSprite(enemy_bullet_x, enemy_bullet_y, 3,4, (int *) shootSprite);  
}
void Shot::drawshot(N5110 &lcd)
{
    lcd.drawSprite(x, y, 3,4, (int *) shootSprite);
}



//------------------------ENEMY DEATH CHECKER---------------------------------//
void enemyDeathChecker(Enemy &enemy1, Enemy &enemy2, Enemy &enemy3, Enemy &enemy4, Shot &shot)
{
    if((!enemy1.enemy_print_flag)&&(!enemy2.enemy_print_flag)&&(!enemy3.enemy_print_flag)&&(!enemy4.enemy_print_flag))
    {
            lcd.clear();
            lcd.printString("WELL DONE ",0,0);
            lcd.printString("Play again? ",1,3);
            lcd.printString("RESET MBED", 1,4);
            lcd.drawSprite(20,7, 8, 12, (int*)enemySprite);
            lcd.refresh();
            wait(100);
        }
        else
        {
            enemy1.enemyMove(enemy1, enemy2, enemy3, enemy4);
            if(enemy1.enemy_print_flag)
            {
                drawEnemy1(lcd, enemy1);
                shot.enemyshoot(enemy1, enemy2, enemy3, enemy4);
            }
            if(enemy2.enemy_print_flag)
            {
                drawEnemy2(lcd, enemy2);
                shot.enemyshoot(enemy1, enemy2, enemy3, enemy4);
            }
            if(enemy3.enemy_print_flag)
            {
                drawEnemy3(lcd, enemy3);
                shot.enemyshoot(enemy1, enemy2, enemy3, enemy4);
            }
            if(enemy4.enemy_print_flag)
            {
                drawEnemy4(lcd, enemy4);
                shot.enemyshoot(enemy1, enemy2, enemy3, enemy4);
            }
        }
}



//--------------------------------Initialisations-----------------------------//
void buttonA_isr()
{
    g_buttonA_flag = 1;   // set flag in ISR
    rgb_led.write(1);
}

void buttonC_isr()
{
    g_buttonC_flag = 1; //set flag in ISR
    rgb_led.write(1);    
}

void initialise()
{
    lcd.init();
    init_leds(); //could initialise the rbb_led()
    joystick.init();
}

//Initialise the rgb led
void init_leds()
{
    rgb_led.write(7); //rgb =7;
}

//Initial menu on scren  
void start_menu()
{  
    lcd.clear();      
    lcd.printString("SPACE INVADERS",1,0);
    lcd.refresh();
    wait_ms(500);
    
    lcd.printString("BY PRALISH S",3,3);
    lcd.refresh();
    wait(1);
     
    lcd.printString("Start = C",0,5);
    lcd.refresh();
    wait(1.5);
    
    lcd.drawSprite(15,8, 8, 12, (int*)enemySprite);    
    lcd.refresh();
    wait_ms(500);
    
    lcd.drawSprite(30,8, 8, 12, (int*)enemySprite);    
    lcd.refresh();
    wait_ms(500);
    
    lcd.drawSprite(45,8, 8, 12, (int*)enemySprite);    
    lcd.refresh();
    wait_ms(500);
    
    lcd.drawSprite(60,8, 8, 12, (int*)enemySprite);    
    lcd.refresh();
    wait(1);
    init_leds();
}



//----------------MAIN FUNCTION RUNNING DOWN BELOW ---------------------------//

int main() {    
    User player;
    Enemy enemy1;
    Enemy enemy2;
    Enemy enemy3;
    Enemy enemy4;
    Shot shot;
    Gameplay game;
    
    //Initialising the game engine
    game.game_init(player, enemy1, enemy2, enemy3, enemy4);
    initialise();
    
    //Only start the game if you press the button
    while (g_buttonC_flag != 1 )
    {
        start_menu();
    }
    
    about_game();
    
    while(1)
    {        
        lcd.drawRect(0,46,84,2,FILL_BLACK);
        game.game_loop(player, enemy1, enemy2, enemy3, enemy4, shot, lcd);
        enemyDeathChecker(enemy1, enemy2, enemy3, enemy4, shot);
        lcd.refresh();
        lcd.clear();
        wait_ms(100);
    }
}