#include "mbed.h"
#include "SDFileSystem.h"
#include "string.h"
typedef struct SensorData {
    char Voltage[8];
    char Current[4];
    char Temperature[1];
    char PanelTemperature[2];//read by the 4 thermistors on solar panels
    char Vcell_soc;//MSBs correspond to Vcell, LSBs to Soc
    char alerts;//UNQUANTISED
    //(alerts[0]=1)-> reset indicator=>dont care
    //(alerts[1]=1)-> Vcell>ValrtMax(5.1V)->will always be high->dont care
    //(alerts[2]=1)-> Vcell<ValrtMin(5.1V)->indicates deep discharge
    //(alerts[3]=1)-> Vcell<Vreset(2.5V)
    //(alerts[5]=1)-> Soc CROSSES the threshold value
    //(alerts[6]=1)-> alert on (alerts[3]) enabled when Vcell<Vreset(here we set it to be 2.5V)
    char crate;
    char BatteryTemperature;    //to be populated   
    char faultpoll;             //polled faults
    char faultir;               //interrupted faults
    char power_mode;            //power modes
    char AngularSpeed[2];
    char Bnewvalue[2];
    
    //float magnetometer,gyro=>to be addes
} SensorData;

void spiwrite(int);
int spiread(int);
int hexint(int);
char* getname(int,int,int,int,int,int,int);
char* getts(void);
void storedata(char*,SensorData*);