#include "mbed.h"
#include "rtos.h"
#include "pinconfig.h"
#include "cdms_sd.h"
#include "MKL46Z4.h"
#include "PL_SC_RECEIVE.h"

Serial main1(USBTX,USBRX);

Thread *ptr_t_sc_data;
Thread *ptr_t_tctm;

InterruptIn pl_sc_data(PIN81);
InterruptIn PYLD_I2C_Int(PIN100);

/* only for sd testing*/
uint8_t write_to_sd[512];
uint8_t read_from_sd[512];
/* end*/

void BAE_HK();
void CDMS_HK();
void PL_MODE();
void FCTN_PL_RCV_SC_DATA();
void FCTN_COM_COMP_SC_DATA();

//extern void FCTN_CDMS_INIT_SD();
//extern int FCTN_CDMS_WR_SD(const uint8_t *, uint64_t);
//extern int FCTN_CDMS_RD_SD(uint8_t *, uint64_t);

//extern void FCTN_CDMS_INIT_SD();
extern int disk_write(const uint8_t *, uint64_t);
extern int disk_read(uint8_t *, uint64_t);
extern int initialise_card();
extern int disk_initialize();

extern void FCTN_CDMS_INIT_RTC();
extern void FCTN_CDMS_RD_RTC();

void TSC_HK_BAE_CDMS_PL_MODE(void const *args)
{
    BAE_HK();
    CDMS_HK();
    PL_MODE();
}

void BAE_HK()
{
    main1.printf("\nBAE_HK Function Executed\r\n");
}

void CDMS_HK()
{
    main1.printf("\nCDMS_HK Function Executed\r\n");
    FCTN_CDMS_RD_RTC();
    disk_write(write_to_sd,4);
    disk_read(read_from_sd,4);
    for(int i=0;i<512;i++)
    {
        main1.printf("%d",read_from_sd[i]);
    }
}

void PL_MODE()
{
    FUNC_MASTER_WRITE;
    main1.printf("\nPL_MODE Function Executed\r\n");
}

void T_CDMS_RLY_TCTM(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x3);
        main1.printf("in T_CDMS_RLY_TM\r\n");
        //FUNC_CDMS_RLY_TM();
    }
}

void T_PL_RCV_SC_DATA(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x1);
        FCTN_PL_RCV_SC_DATA();
        FCTN_COM_COMP_SC_DATA();
        FCTN_CDMS_RD_RTC();
        disk_write(write_to_sd,2);
        disk_read(read_from_sd,2);
        for(int i=0;i<512;i++)
        {
            main1.printf("%d",read_from_sd[i]);
        }
    }
}

void ISR_PL_RCV_SC_DATA()
{
    ptr_t_sc_data->signal_set(0x1);
}

void FCTN_PL_RCV_SC_DATA()
{
    payloadProcess();
    main1.printf("\nFCTN_PL_RCV_SC_DATA Function Executed\r\n");
}

void FCTN_COM_COMP_SC_DATA()
{
    main1.printf("\nFCTN_COM_COMP_SC_DATA Function Executed\r\n");
}

void FCTN_CDMS_WR_SD()
{
    main1.printf("\nFCTN_CDMS_WR_SD Function Executed\r\n");
}

int main()
{
    main1.printf("\n\r CDMS Activated \n");
    initialise_card();
    disk_initialize();
    FCTN_CDMS_INIT_RTC();
    FCTN_CDMS_PL_INIT();
    
    
    for(int i=0;i<512;i++)
    {
        write_to_sd[i] = i;
    }   
    RtosTimer TIMER_HK_ACQ(TSC_HK_BAE_CDMS_PL_MODE,osTimerPeriodic);
    TIMER_HK_ACQ.start(10000);
    ptr_t_tctm = new Thread (T_CDMS_RLY_TCTM);
    ptr_t_sc_data = new Thread (T_PL_RCV_SC_DATA);
    pl_sc_data.rise(&ISR_PL_RCV_SC_DATA);
    PYLD_I2C_Int.rise(&readds);
    while(1);
}