#include "mbed.h"
#include "rtos.h"

Serial pc(USBTX, USBRX);


Thread *ptr_hk_bae;
Thread *ptr_hk_cdms;
Thread *ptr_hk_payload;

InterruptIn data_ready1(PTC3);


Timer t1;



void HK_BAE(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x1);
        printf("Entered HK_BAE\n");
    }
}

void FUNC_INIT_HK_PAYLOAD()
{
   
    ptr_hk_payload -> signal_set(0x3); 

}
void HK_CDMS(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x2);
        printf("Entered HK_CDMS\n");
        
    }
}
void HK_PAYLOAD(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x3);
        printf("Entered HK_PAYLOAD\n");
    }
}

uint16_t schedcount=1;

void T_SC(void const *args)
{
    
    printf("The value of i in scheduler is %d\n",schedcount);
    if(schedcount == 65532)                         //to reset the counter
    {
        schedcount = 0;
    }
    
    if(schedcount%20==0)
    {
        ptr_hk_bae -> signal_set(0x1);
        ptr_hk_cdms -> signal_set(0x2);
        
    }
   schedcount++;
}
 
 
int main()
{
    ptr_hk_bae = new Thread (HK_BAE);
      data_ready1.rise(&FUNC_INIT_HK_PAYLOAD);
    
    ptr_hk_cdms=new Thread (HK_CDMS);
    ptr_hk_payload=new Thread (HK_PAYLOAD);
    
    ptr_hk_bae->set_priority(osPriorityAboveNormal);
    ptr_hk_cdms->set_priority(osPriorityNormal);
    ptr_hk_payload->set_priority(osPriorityHigh);
    
    printf("\n T_HK_BAE priority is %d",ptr_hk_bae->get_priority());
    printf("\n T_HK_CDMS priority is %d",ptr_hk_cdms->get_priority());
    printf("\n T_HK_PAYLOAD priority is %d",ptr_hk_payload->get_priority());
    
    RtosTimer t_sc_timer(T_SC,osTimerPeriodic);
    t_sc_timer.start(1000);
    
    
    while(1)
    {   
         Thread::wait(5000);
    }
    
    
    
}
    

