#include "mbed.h"
#include "func_head.h"

Serial sr(USBTX,USBRX);

SPISlave pl_spi(PTE18, PTE19, PTE17, PTE16 ); // mosi, miso, sclk, ssel --> using SPI1
//SPISlave pl_spi(PTD6, PTD7, PTD5, PTD4   ); // mosi, miso, sclk, ssel --> using SPI1
int payloadBins = 4;

void FUNC_PL_RCV_SC_DATA()
{
        sr.printf("in FUNC_PL_RCV_SC_DATA\r\n");
        uint8_t scienceRawPacket[payloadBins];
        for(int i=0; i<payloadBins;i++)
        {
            while(!pl_spi.receive()); // blocking statement --> waiting for data from Payload
            uint8_t v = pl_spi.read();   // Read byte from master
            scienceRawPacket[i] = v;
        }
        // serial feedback
        sr.printf("Packet recieved\r\r\n");
        for(int i=0;i<payloadBins;i++)
        {
            sr.printf("%0x\t",scienceRawPacket[i]);
            scienceRawPacket[i] = 0;
        }
        sr.printf("\r\r\n");
}