#include "mbed.h"
#include "rtos.h"
#include "func_head.h"
#include "i2c.h"
#include "SDCard.h"
#define HK_DATA 25
#define HK_ITER 15
Serial pc(USBTX,USBRX);

extern SPISlave pl_spi ; // mosi, miso, sclk, ssel --> using SPI1

InterruptIn pl_sc_data(PTC3);
InterruptIn cdms_rcv_tc(PTC12);
InterruptIn bae_tm_rcv(PTC11);
InterruptIn pl_tm_rcv(PTC10);
extern I2C master;
extern DigitalOut irpt_2_slv;

char i2c_data[25];
int hk_count=0;
uint8_t hk_data[512];
uint8_t* rtc_data;
uint64_t hk_block_number = 1;

/*****************************************************************Threads USed*************************************************************************/
Thread *ptr_t_hk_acq;              //pointer:::::::::to read state of one thread from another
Thread *ptr_t_sc_data;
Thread *ptr_t_tc;
Thread *ptr_t_tm;
Thread *ptr_t_fault;
Thread *ptr_t_wdt;

void T_CDMS_RLY_TC(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x2);
        pc.printf("in T_CDMS_RLY_TC\r\n");
        FUNC_CDMS_RLY_TC();
    }
}

void T_CDMS_RLY_TM(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x3);
        pc.printf("in T_CDMS_RLY_TM\r\n");
        FUNC_CDMS_RLY_TM();
    }
}

void T_PL_RCV_SC_DATA(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x1);
        pc.printf("in T_PL_RCV_SC_DATA\r\n");
        FUNC_PL_RCV_SC_DATA();
    }
}
         
void TSC_CDMS_HK_MAIN(void const *args)
{
    pc.printf("in FUNC_CDMS_HK_MAIN()\r\n");
    FCTN_MASTER_I2C('h' , i2c_data );
    FUNC_CDMS_RD_RTC(rtc_data);
    for(int i=(hk_count%(HK_ITER+1)+hk_count*(HK_DATA+8));i<(hk_count%(HK_ITER+1)+hk_count*(HK_DATA+8))+8;i++)
    {
        hk_data[i] = rtc_data[i];
    }
    for(int i=(hk_count%(HK_ITER+1)+hk_count*(HK_DATA+8))+8;i<(hk_count%(HK_ITER+1)+hk_count*(HK_DATA+8))+8+HK_DATA;i++)
    {
        hk_data[i] = i2c_data[i];
    }
    hk_count++;
    if(hk_count%15==0)
    {
        for(int i=((hk_count-1)%(HK_ITER+1)+(hk_count-1)*(HK_DATA+8))+8+HK_DATA;i<512;i++)
        {
            hk_data[i] = '/0';
        }
        hk_count = 0;
        FUNC_WR_SD(hk_data,hk_block_number);
        for(int i=0;i<512;i++)
        {
            hk_data[i] = '/0';
        }
        FUNC_RD_SD(hk_data,hk_block_number);
        hk_block_number;
        printf("\n\r sd card hk data\n");
        for(int i=0;i<512;i++)
        {
            pc.printf("%d|",hk_data[i]);
        }
    }
    pc.printf("\n\r hk exited\n");
}

void ISR_PL_RCV_SC_DATA()
{
    ptr_t_sc_data->signal_set(0x1);
}

void ISR_CDMS_RLY_TC()
{
    ptr_t_tc->signal_set(0x2);
}

void ISR_CDMS_RLY_TM()
{
    ptr_t_tm->signal_set(0x3);
}

int main() {
    printf("\n\r CDMS Activated \n");
    ptr_t_tc = new Thread (T_CDMS_RLY_TC);
    ptr_t_tm = new Thread (T_CDMS_RLY_TM);
    ptr_t_sc_data = new Thread (T_PL_RCV_SC_DATA);
    master.frequency(100000);
    RtosTimer TIMER_HK_ACQ(TSC_CDMS_HK_MAIN,osTimerPeriodic);
    TIMER_HK_ACQ.start(20000);
    irpt_2_slv = 1;
    pl_sc_data.rise(&ISR_PL_RCV_SC_DATA);
    cdms_rcv_tc.rise(&ISR_CDMS_RLY_TC);
    bae_tm_rcv.rise(&ISR_CDMS_RLY_TM);
    pl_tm_rcv.rise(&ISR_CDMS_RLY_TM);
    
    pl_spi.format(8,3);  // SPI format --> 16 bits, mode = 0
    pl_spi.frequency(1000000);
    
    FUNC_INIT_RTC();
    int *status_sd = FUNC_INIT_SD();
    
    while(1);
}