#include "mbed.h"
//#include "pin_config.h"
#include "i2c.h"

Serial gc(USBTX,USBRX);
InterruptIn irpt_4m_slv(D9);                                      //I2c interrupt from CDMS
DigitalOut irpt_2_slv(D8);                                        //I2C interrupt to CDMS
I2C master(D14,D15);



const int addr = 0x20;                                            //slave address 
Timer t;


void FCTN_I2C_READ(char *data, int length )
{
    bool read_ack = true;
    irpt_2_slv = 0; 
    t.start();
    read_ack=master.read(addr|1,data,length);
    t.stop();
    if(read_ack == 0)
        printf("\r\n\rData received from BAE is %s \r\n",data);
    else
    {
        printf("\r\n \r data not received \r\n");
        master.stop();
    }
    irpt_2_slv = 1;
    printf("\r\n\r %d \r\n",t.read_us());
    t.reset();
}

void FCTN_I2C_WRITE(char *data,int length)
{
    bool write_ack = true;
    irpt_2_slv = 0;
    t.start();
    write_ack=master.write(addr|0x00,data,length);
    t.stop();
    if(write_ack == 0)
        printf("\r\n\rData sent to BAE is %s \r\n",data);
    else 
    {
        printf("\r\n\r data not sent \r\n");
        master.stop();
    }
    irpt_2_slv = 1;
    printf("\r\n\r %d \r\n",t.read_us());
    t.reset();
}

bool check = 1;
void FCTN_MASTER_I2C(char i2c_data_type , char* i2c_data)
{
    FCTN_I2C_WRITE(&i2c_data_type,1); 
    wait_ms(10);
    switch(i2c_data_type)
    {
        case 's':
        FCTN_I2C_WRITE(i2c_data,11);
        break;
            
        case 'l':
        FCTN_I2C_WRITE(i2c_data,135);
        break;
            
        case 'h':
        FCTN_I2C_READ(i2c_data,25);
        break;
            
        default:
        printf("\r\n\r invalid command \r\n");
    }
}