#include "HK_CDMS.h"
#include "pin_config.h"
 
 
Serial hk_cdms(USBTX, USBRX);
//DigitalOut Select_Lines_C[]={PIN85,PIN84,PIN39,PIN38};  //to mux on IF board,from LSB(Select_Lines_C[3]) to MSB(Select_Lines_C[0])
DigitalOut Select_Lines_C[]={D7,D6,D5,D4};
AnalogIn Temperature_voltage_Input(PIN53);  //output from IF mux
//AnalogIn Sensor_Input(PIN53);    //output from temperature sensor on CDMS
char CDMS_HK_DATA[8];
 
void FCTN_CDMS_HK_INIT()
{
    Select_Lines_C[0] = Select_Lines_C[1] = Select_Lines_C[2] = Select_Lines_C[3] = 0;  //initialisation of variables
}
 
int quantiz(float l_start,float l_step,float l_x)       // accepts min and measured values and step->quantises on a scale 0-15..(4 bit quantisation)
{
    int l_y = (l_x - l_start)/l_step;
        
    if(l_y <= 0)
            l_y = 0;
            
    if(l_y >= 15)
            l_y = 15;
            
    return l_y;
} 
 
Sensor_Data Sensor; 
Sensor_Data_Quantised Sensor_Quantised;
 
char* FCTN_CDMS_HK_MAIN()
{
    float l_resistance_thermistor;  //declaration of variables
    float l_voltage_thermistor;
    float l_Payload_voltage;
    int l_Loop_Iterator = 0;
    int l_Select_Line_Iterator = 3;
 
    for(l_Loop_Iterator = 0; l_Loop_Iterator < 16; l_Loop_Iterator++)
    {
 
        l_voltage_thermistor = Temperature_voltage_Input.read()*3.3;       //voltage across thermistor
        l_resistance_thermistor = 24000*l_voltage_thermistor/(3.3 - l_voltage_thermistor);           //resistance of thermistor
        l_Payload_voltage = Temperature_voltage_Input.read()*3.3;
               
        Sensor.l_Temperature_thermistor[(l_Loop_Iterator)] = 0.00000004*l_resistance_thermistor*l_resistance_thermistor - 0.0039*l_resistance_thermistor + 347.97;
        Sensor.l_Temperature_sensor[l_Loop_Iterator] = (-90.7*3.3*Temperature_voltage_Input.read() + 190.1543);  
              
        if(l_Loop_Iterator % 2 == 0) 
        {
             if(l_Loop_Iterator < 4)
             Sensor_Quantised.l_Temperature_thermistor[(l_Loop_Iterator)/2] = quantiz(tstart_thermistor,tstep_thermistor,Sensor.l_Temperature_thermistor[(l_Loop_Iterator)]);
               
             else  
             {
                if(4 < l_Loop_Iterator < 14)
                Sensor_Quantised.l_Payload_voltage[(l_Loop_Iterator)/2] = Sensor_Quantised.l_Payload_voltage[(l_Loop_Iterator)/2] <<4 + quantiz(tstart,tstep,Sensor.l_Payload_voltage[l_Loop_Iterator]); 
                
                else
                Sensor_Quantised.l_Temperature_sensor[(l_Loop_Iterator)/2] = quantiz(tstart,tstep,Sensor.l_Temperature_sensor[l_Loop_Iterator]); 
             }
        }
                                              
        else
        {
            
            if(l_Loop_Iterator < 4)
            Sensor_Quantised.l_Temperature_thermistor[(l_Loop_Iterator)/2] = Sensor_Quantised.l_Temperature_thermistor[(l_Loop_Iterator)/2] <<4 + quantiz(tstart_thermistor,tstep_thermistor,Sensor.l_Temperature_thermistor[l_Loop_Iterator]);
            
            else
            {
                if(4 < l_Loop_Iterator < 14)
                Sensor_Quantised.l_Payload_voltage[(l_Loop_Iterator)/2] = quantiz(tstart,tstep,Sensor.l_Payload_voltage[l_Loop_Iterator]);
                
                else
                Sensor_Quantised.l_Temperature_sensor[(l_Loop_Iterator)/2] = Sensor_Quantised.l_Temperature_sensor[(l_Loop_Iterator)/2] <<4 + quantiz(tstart,tstep,Sensor.l_Temperature_sensor[l_Loop_Iterator]); 
        
            }
        }
    
       
          
       // The following lines are used to iterate the select lines from 0 to 15
       for(l_Select_Line_Iterator = 3;l_Select_Line_Iterator >= 0;l_Select_Line_Iterator--)
       {
            if(Select_Lines_C[l_Select_Line_Iterator] == 0)
            {
                Select_Lines_C[l_Select_Line_Iterator] = 1;
                break;
            }
            else Select_Lines_C[l_Select_Line_Iterator] = 0;
            printf("%d\n",l_Select_Line_Iterator);
       }
      
        wait_us(10.0); //  A delay of 10 microseconds between each sensor output. Can be changed.
    }
     printf("vol %f temp %f",Temperature_voltage_Input.read()*3.3,-90.7*3.3*Temperature_voltage_Input.read() + 190.1543 );
     printf("CDMS_HK Data is Temperature_sensor=%s, l_Temperature_thermistor=%s, Payload_voltage=%s ",Sensor_Quantised.l_Temperature_sensor,Sensor_Quantised.l_Temperature_thermistor,Sensor_Quantised.l_Payload_voltage);
     strcpy (CDMS_HK_DATA,Sensor_Quantised.l_Temperature_sensor);
     strcat (CDMS_HK_DATA,Sensor_Quantised.l_Temperature_thermistor);
     strcat (CDMS_HK_DATA,Sensor_Quantised.l_Payload_voltage);
     return(CDMS_HK_DATA);
}