#include "mbed.h"
//SIZE
#define TC_SHORT_SIZE 11
#define TC_LONG_SIZE 135
#define TM_LONG_SIZE 134
#define TM_SHORT_SIZE 13

//TELECOMMAND:

// exec_status:
// 0: unexecuted
// 1: successfully executed
// 2: Execution Failed
// 3: Disabled
// 4: Marked For retry

//MASKS
#define SHORT_LONG_TC_MASK 0x10
#define CRC_MASK 0x08
#define EXEC_STATUS_MASK 0x07

//USE ONLY THE BELOW MACROS TO MODIFY 'flags' VARIABLE
//x should be a Base_tc pointer
#define GETshort_or_long_tc(x) ( ( (x->flags) & SHORT_LONG_TC_MASK ) >> 4 )
#define GETcrc_pass(x) ( ( (x->flags) & CRC_MASK ) >> 3 )
#define GETabort_on_nack(x) ( ( (x->TC_string[1]) & 0x08 ) >> 3 )
#define GETapid(x) ( ( (x->TC_string[1]) & 0xC0 ) >> 6 )
#define GETexec_status(x) ( (x->flags) & EXEC_STATUS_MASK )
#define GETpacket_seq_count(x) (x->TC_string[0])
#define GETservice_type(x) ( (x->TC_string[2]) & 0xF0 )
#define GETservice_subtype(x) ( (x->TC_string[2]) & 0x0F )
#define GETpid(x) (x->TC_string[3])

//x should be a Base_tc pointer
//y should be a 16-bit number with relevant data in LSB
//use in a seperate line with ; at the end: similar to a function
#define PUTshort_or_long(x,y) x->flags = ( (x->flags) & ~(SHORT_LONG_TC_MASK)) | ( (y << 4) & SHORT_LONG_TC_MASK )
#define PUTcrc_pass(x,y) x->flags = ( (x->flags) & ~(CRC_MASK)) | ( (y << 3) & CRC_MASK)
#define PUTexec_status(x,y) x->flags = ( (x->flags) & ~(EXEC_STATUS_MASK)) | ( y & EXEC_STATUS_MASK)

//PARENT TELECOMMAND CLASS 
class Base_tc{
public:
    uint8_t flags;
    uint8_t *TC_string;
    Base_tc *next_TC;
    
    virtual ~Base_tc(){}
};

//DERIVED CLASS - SHORT TC
class Short_tc : public Base_tc{
private:
    uint8_t fix_str[TC_SHORT_SIZE];
public:
    Short_tc(){
        TC_string = fix_str;
        flags = 0;
    }
    
    ~Short_tc(){}
};

//DERIVED CLASS - LONG TC
class Long_tc : public Base_tc{
private:
    uint8_t fix_str[TC_LONG_SIZE];
public:
    Long_tc(){
        TC_string = fix_str;
        flags = 0;
    }
    
    ~Long_tc(){}
};

// TELEMETRY:
// MASKS
#define SHORT_LONG_TM_MASK 0x10
#define TMID_MASK 0x0F

//x should be 'fields' variable defined in the Base_tm
#define GETshort_or_long_tm(x) ((x & SHORT_LONG_TM_MASK) >> 4)
#define GETtmid(x) (x & TMID_MASK)

//x should be 'fields' variable defines in the Base_tm
//y should be an 8-bit number with relevent data at LSB
#define PUTshort_or_long_tm(x,y) x = (x & ~(SHORT_LONG_TM_MASK)) | ((y<<4) & SHORT_LONG_TM_MASK)
#define PUTtmid(x,y) x = (x & ~(TMID_MASK)) | (y & TMID_MASK)

// PARENT TELEMETRY CLASS
class Base_tm{
public:
    uint8_t fields;
    uint8_t *TM_string;
    Base_tm *next_TM;
    
    virtual ~Base_tm(){}
};

// DERIVED CLASS : Long tm [type 0]
// type 0
class Long_tm : public Base_tm{
private:
    uint8_t fix_str[TM_LONG_SIZE];
public:
    Long_tm(){
        TM_string = fix_str;
        // type 0
        fields = 0;
    }
    
    ~Long_tm(){}
};

// DERIVED CLASS : Short tm [type 1]
// type 1
class Short_tm : public Base_tm{
private:
    uint8_t fix_str[TM_SHORT_SIZE];
public:
    Short_tm(){
        TM_string = fix_str;
        // type 1
        fields = 0x10;
    }
    
    ~Short_tm(){}
};

//////////////////////////////END
















/*typedef struct TC_list{
    // received from the RCV_TC
    unsigned char *TC_string;
    bool short_or_long; //'true' for short
    bool crc_pass;
 
    // updated info - updated in MNG_TC
    unsigned char packet_seq_count;
    unsigned char apid;
    bool abort_on_nack;
    bool enabled;
//    bool valid_execution;
    unsigned char exec_status;
 
    struct TC_list *next_TC;
    
    ~TC_list(){}
}TC_list;
 
typedef struct TM_list{
 
    unsigned char *TM_string;
    // bool short_or_long; // true for short
    // pass while calling the function
    unsigned char tmid;
    struct TM_list *next_TM;
    
    ~TM_list(){}
}TM_List;*/






















////PARENT CLASS
//class Base_tc{
//public:
//    uint16_t fields;
//    uint8_t *TC_string;
//    Base_tc *next_node;
    
//    short = 0, long = 1
//    bool GETshort_or_long(void){
//        return (fields & SHORT_LONG_TC_MASK);
//    }
//    void PUTshort_or_long(bool input){
//        if(input){
//            fields |= SHORT_LONG_TC_MASK;
//        }
//        else{
//            fields &= ~(SHORT_LONG_TC_MASK);
//        }
//    }
//    
//    bool inline GETcrc_pass(){
//        return (fields & CRC_MASK);
//    }
//    void inline PUTcrc_pass(bool input){
//        if(input){
//            fields |= CRC_MASK;
//        }
//        else{
//            fields &= ~(CRC_MASK);
//        }
//    }
//        
//    bool inline GETabort_on_nack(){
//        return (fields & ABORT_ON_NACK_MASK);
//    }
//    void inline PUTabort_on_nack(bool input){
//        if(input){
//            fields |= ABORT_ON_NACK_MASK;
//        }
//        else{
//            fields &= ~(ABORT_ON_NACK_MASK);
//        }
//    }
//    
//    uint8_t inline GETapid(){
//        uint16_t temp = fields & APID_MASK;
//        temp = temp >> 10;
//        return (temp & 0xFF);
//    }
//    void inline PUTapid(uint8_t input){
//        uint16_t temp = input;
//        temp = temp << 10;
//        fields &= ~(APID_MASK);
//        fields |= (temp & APID_MASK);
//    }
//    
//    uint8_t inline GETexec_status(){
//        uint16_t temp = fields & EXEC_STATUS_MASK;
//        temp = temp >> 8;
//        return (temp & 0xFF);
//    }
//    void inline PUTexec_status(uint8_t input){
//        uint16_t temp = input;
//        temp = temp << 8;
//        fields &= ~(EXEC_STATUS_MASK);
//        fields |= (temp & EXEC_STATUS_MASK);
//    }
//    
//    uint8_t inline GETpacket_seq_count(){
//        uint16_t temp = fields & PACKET_SEQ_COUNT_MASK;
//        return (temp & 0xFF);
//    }
//    void inline PUTpacket_seq_count(uint8_t input){
//        uint16_t temp = input;
//        fields &= ~(PACKET_SEQ_COUNT_MASK);
//        fields |= (temp & PACKET_SEQ_COUNT_MASK);
//    }
//    
////    update everything other than short_or_long, and crc_pass from TC_string
//    void update_fields(){
////        abort on nack
//        uint8_t temp = TC_string[1];
//        uint16_t t16 = 0;
//        if(temp & 0x10){
//            fields |= ABORT_ON_NACK_MASK;
//        }
//        else{
//            fields &= ~(ABORT_ON_NACK_MASK);
//        }
//        
//        // apid
//        t16 = temp;
//        t16 = t16 << 4;
//        fields &= ~(APID_MASK);
//        fields |= (t16 & APID_MASK);
//        
//        // exec_status : default value of exec status
//        fields &= ~(EXEC_STATUS_MASK);
//        
//        // packet seq count
//        temp = TC_string[0];
//        t16 = temp;
//        fields &= ~(PACKET_SEQ_COUNT_MASK);
//        fields |= (t16 & PACKET_SEQ_COUNT_MASK);
//    }
//    
//    virtual ~Base_tc(){}
//};

////DERIVED CLASS - SHORT TC
//class Short_tc : public Base_tc{
//private:
//    uint8_t fix_str[TC_SHORT_SIZE];
//public:
//    Short_tc(){
//        TC_string = fix_str;
//        fields = 0;
//    }
//    
//    ~Short_tc(){}
//};
//
////DERIVED CLASS - LONG TC
//class Long_tc : public Base_tc{
//private:
//    uint8_t fix_str[TC_LONG_SIZE];
//public:
//    Long_tc(){
//        TC_string = fix_str;
//        fields = 0;
//    }
//    
//    ~Long_tc(){}
//};

//// TELEMETRY CLASS :
//
//// MASKS
//#define SHORT_LONG_TM_MASK 0x10
//#define TMID_MASK 0x0F
//
//// PARENT CLASS
//class Base_tm{
//protected:
//    uint8_t fields;
//public:
//    uint8_t *TM_string;
//    Base_tm *next_node;
//    
    // short = 0, long = 1
//    bool GETshort_or_long(){
//        return (fields & SHORT_LONG_TM_MASK);
//    }
//    void PUTshort_or_long(bool input){
//        if(input){
//            fields |= SHORT_LONG_TM_MASK;
//        }
//        else{
//            fields &= ~(SHORT_LONG_TM_MASK);
//        }
//    }
//    
//    uint8_t GETtmid(){
//        return (fields & TMID_MASK);
//    }
//    void PUTtmid(uint8_t input){
//        fields &= ~(TMID_MASK);
//        fields |= (input & TMID_MASK);
//    }
//    
//    virtual ~Base_tm(){}
//};


//// DERIVED CLASS : Long tc [type 0]
//// type 0
//class Long_tm : public Base_tm{
//private:
//    uint8_t fix_str[TM_LONG_SIZE];
//public:
//    Long_tm(){
//        TM_string = fix_str;
//        // type 0
//        fields = 0;
//    }
//    
//    ~Long_tm(){}
//};
//
//// DERIVED CLASS : Short tc [type 1]
//// type 1
//class Short_tm : public Base_tm{
//private:
//    uint8_t fix_str[TM_SHORT_SIZE];
//public:
//    Short_tm(){
//        TM_string = fix_str;
//        // type 1
//        fields = 0x10;
//    }
//    
//    ~Short_tm(){}
//};