#include "mbed.h"
#include "rtos.h"
#include "pinconfig.h"
#include "cdms_sd.h"
#include "structure.h"
#include "i2c.h"
#include "cdms_rtc.h"
#include "main_funcs.h"
#include "CDMS_HK.h"
#include "TMTC.h"
#include "main.h"


Serial pc(USBTX,USBRX);

Thread *ptr_t_sc_data;
Thread *ptr_t_tmtc;

InterruptIn pl_sc_data(PIN81);
InterruptIn cdms_rcv_tc(PIN38);
extern DigitalOut irpt_2_slv;


/* only for sd testing*/
uint8_t write_to_sd[512];
uint8_t read_from_sd[512];
/*end*/

Base_tc *tc_test = new Long_tc;
Base_tm *tm_test = new Long_tm;




void TSC_HK_BAE_CDMS_PL_MODE(void const *args)
{
    
    FCTN_CDMS_HK_MAIN();
   
}

void BAE_HK()
{
    printf("\n\rBAE_HK Function Executed\r\n");
}



void PL_MODE()
{
    printf("\n\rPL_MODE Function Executed\r\n");
   
}

void T_CDMS_RLY_TMTC(void const *args)
{
   
        
        printf("\rin T_CDMS_RLY_TMTC\r\n");
        printf("\r \n Enter a valid TC \n\r");
        uint8_t read;
        /* for(int i=0;i <4 ; i++)
         {
             scanf("%d",&tc_test->TC_string[i]);
          }*/
     
    tc_test->TC_string[0] = 43;
    tc_test->TC_string[1] = 0x40;
    tc_test->TC_string[2] = 0x81;
    tc_test->TC_string[3] = 0x13;
        
        for(int i=4;i < 135 ; i++)
            tc_test->TC_string[i] = 43; 
        printf("%s", tc_test->TC_string);
        tm_test = FCTN_CDMS_RLY_TMTC(tc_test);
        printf("%s", tm_test->TM_string);
//        for(int i =0;i<134;i++)\
//        {
//            printf("ack");
//            printf("%c", tm_test->TM_string[i]);
//        }
        //FUNC_CDMS_RLY_TM();
    
}

void T_PL_RCV_SC_DATA(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x1);
        //uint8_t* buff=FCTN_PL_RCV_SC_DATA();
        uint8_t* buff;
        FCTN_COM_COMP_SC_DATA();
        FCTN_CDMS_RD_RTC();
        uint8_t fsc=FCTN_SD_MNGR(0x0);
        SD_WRITE(buff,fsc,0x0);
        /*for(int i=0;i<512;i++)
        {
            printf("%d",read_from_sd[i]);
        }*/
    }
}

void ISR_PL_RCV_SC_DATA()
{
    ptr_t_sc_data->signal_set(0x1);
}

/*uint8_t* FCTN_PL_RCV_SC_DATA()
{
    printf("\n\rFCTN_PL_RCV_SC_DATA Function Executed\r\n");
    uint8_t buff[512];
    for(int i=0;i<512;i++)
        {
            buff[i]=0x32;
        }
    return buff;
    
} */

void FCTN_COM_COMP_SC_DATA()
{
    printf("\n\rFCTN_COM_COMP_SC_DATA Function Executed\r\n");
}



void ISR_TMTC_THREAD()
{
    ptr_t_tmtc->signal_set(0x3);
}
    

int main()
{
    irpt_2_slv=0;
    FCTN_CDMS_SD_INIT();
    FCTN_CDMS_INIT_RTC();
    RtosTimer TIMER_HK_ACQ(T_CDMS_RLY_TMTC,osTimerPeriodic);
    TIMER_HK_ACQ.start(20000);
    ptr_t_tmtc = new Thread (T_CDMS_RLY_TMTC);
    ptr_t_sc_data = new Thread (T_PL_RCV_SC_DATA);
    pl_sc_data.rise(&ISR_PL_RCV_SC_DATA);
    cdms_rcv_tc.rise(&ISR_TMTC_THREAD);
   while(1)
    {
        Thread::wait(10);
        
    }
}