#include "mbed.h"
#include "FreescaleIAP.h"
#include "Flash.h"

int strt_add = flash_size() - (4*SECTOR_SIZE);  
uint32_t flasharray[256+(3*1024)];
char *nativeflash = (char*)strt_add;

/*Writing to the Flash*/
void FCTN_CDMS_WR_FLASH(uint16_t j,uint32_t block)
{
    for(int64_t i=0;i<(256+(3*1024));i++)
    {
        flasharray[i]=nativeflash[i];
    }
    flasharray[j]=block;
    erase_sector(strt_add);
    program_flash(strt_add, (char*)&flasharray,4*(256+(1024*3)));
}
/*End*/

/*Reading from Flash*/
uint32_t FCTN_CDMS_RD_FLASH(uint16_t j)
{
    for(int64_t i=0;i<(256+(3*1024));i++)
    {
        flasharray[i]=nativeflash[i];
    }
    return flasharray[j];
}
/*End*/