#include "mbed.h"
#include "rtos.h"
#include "pinconfig.h"
#include "cdms_sd.h"
#include "structure.h"
#include "i2c.h"
#include "cdms_rtc.h"
#include "main_funcs.h"
#include "TMTC.h"

Serial pc(USBTX,USBRX);

Thread *ptr_t_sc_data;
Thread *ptr_t_tmtc;

InterruptIn pl_sc_data(PIN81);

/* only for sd testing*/
uint8_t write_to_sd[512];
uint8_t read_from_sd[512];
/*end*/

Base_tc *tc_test = new Long_tc;
Base_tm *tm_test = new Long_tm;

void TSC_HK_BAE_CDMS_PL_MODE(void const *args)
{
    BAE_HK();
    CDMS_HK();
    PL_MODE();
}

void BAE_HK()
{
    printf("\n\rBAE_HK Function Executed\r\n");
}

void CDMS_HK()
{
    printf("\n\rCDMS_HK Function Executed\r\n");
    uint64_t time = FCTN_CDMS_RD_RTC();
    printf("\n\r0x%016llx\n\r", time);
    disk_write(write_to_sd,4);
    disk_read(read_from_sd,4);
    for(int i=0;i<512;i++)
    {
        printf("%d",read_from_sd[i]);
    }
}

void PL_MODE()
{
    printf("\n\rPL_MODE Function Executed\r\n");
    ptr_t_tmtc->signal_set(0x3);
}

void T_CDMS_RLY_TMTC(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x3);
        printf("\rin T_CDMS_RLY_TM\r\n");
        tc_test->TC_string[0] = 43;
        tc_test->TC_string[1] = 81;
        tc_test->TC_string[2] = 97;
        tc_test->TC_string[3] = 80;
        for(int i=4;i < 135 ; i++)
            tc_test->TC_string[i] = 43; 
        printf("%s", tc_test->TC_string);
        tm_test = FCTN_CDMS_RLY_TMTC(tc_test);
        printf("%s", tm_test->TM_string);
//        for(int i =0;i<134;i++)\
//        {
//            printf("ack");
//            printf("%c", tm_test->TM_string[i]);
//        }
        //FUNC_CDMS_RLY_TM();
    }
}

void T_PL_RCV_SC_DATA(void const *args)
{
    while(1)
    {
        Thread::signal_wait(0x1);
        FCTN_PL_RCV_SC_DATA();
        FCTN_COM_COMP_SC_DATA();
        FCTN_CDMS_RD_RTC();
        disk_write(write_to_sd,2);
        disk_read(read_from_sd,2);
        for(int i=0;i<512;i++)
        {
            printf("%d",read_from_sd[i]);
        }
    }
}

void ISR_PL_RCV_SC_DATA()
{
    ptr_t_sc_data->signal_set(0x1);
}

void FCTN_PL_RCV_SC_DATA()
{
    printf("\n\rFCTN_PL_RCV_SC_DATA Function Executed\r\n");
}

void FCTN_COM_COMP_SC_DATA()
{
    printf("\n\rFCTN_COM_COMP_SC_DATA Function Executed\r\n");
}

void FCTN_CDMS_WR_SD()
{
    printf("\n\rFCTN_CDMS_WR_SD Function Executed\r\n");
}

int main()
{
    printf("\n\r CDMS Activated \r\n");
    initialise_card();
    disk_initialize();
    FCTN_CDMS_INIT_RTC();
    for(int i=0;i<512;i++)
    {
        write_to_sd[i] = i;
    }     
    RtosTimer TIMER_HK_ACQ(TSC_HK_BAE_CDMS_PL_MODE,osTimerPeriodic);
    TIMER_HK_ACQ.start(10000);
    ptr_t_tmtc = new Thread (T_CDMS_RLY_TMTC);
    ptr_t_sc_data = new Thread (T_PL_RCV_SC_DATA);
    pl_sc_data.rise(&ISR_PL_RCV_SC_DATA);

    while(1);
}