/*mbed motorlib Library for H-Bridge Motor Driver Using Bipolar Transistors
*  
* mbed simple H-bridge motor controller
* Copyright (c) 2007-2012, Prabhu Desai
* 

*/
 
#ifndef MBED_MOTOR_H
#define MBED_MOTOR_H
 
#include "mbed.h"
 
#define LM293D_MOTOR_CTRL 
/** Interface to control a standard DC motor 
* 
*/
class Motor {
    public:
    /** Motor Control Type */
    enum MCtrlType {
          L293D_DISCRETE   /**< 0 or 100% duty cycle with  L293D */
        , L293D_PWM        /**< PWM based voltage control  with L293D */
        , COMPS_DISCRETE   /**< 0 or 100% duty cycle with transistor circuit*/
        , COMPS_PWM        /**< PWM based voltage control with transistor circuit*/       

    };    
 
/** Create a motor control interface    
*
* @param r1 DigitalOut, driving  H-bridge NPN transistor on the BOTTOm right
* @param r2 DigitalOut, driving  H-bridge PNP transistor on the TOP right
* @param r3 DigitalOut, driving  H-bridge NPN transistor on the BOTTOm left.
* @param r4 DigitalOut, driving  H-bridge PNP transistor on the TOP left
* @param mctype DigitalOut, driving  H-bridge PNP transistor on the TOP left
*/
       Motor(PinName r1, PinName r4,MCtrlType mctype =L293D_PWM);
       Motor(PinName r1, PinName r2, PinName r3, PinName r4,MCtrlType mctype =L293D_PWM);
  
/** Set the motor to coast/roll/off
* 
* @param void
* @return void 
*/
        void coast(void);  
        
/** Rotate motor in clockwise direction.
* 
* @param void 
* @return void
*/
        void forward(void);
        
/** /** Rotate motor in Anti-clockwise direction.
* 
* @param void 
* @return void
*/        
  
        void backward(void);

/** Stop the motor.
* 
* @param void 
* @return void
*/

        void stop(void);
   
    protected:
      #ifdef LM293D_MOTOR_CTRL
        PwmOut _r1;
        PwmOut _r4;  
      #else 
        DigitalOut _r1;
        DigitalOut _r2;
        DigitalOut _r3;
        DigitalOut _r4;      
      #endif   
        MCtrlType _mctype;
 
};
 
#endif
