/* mbed motorlib Library for H-Bridge Motor Driver Using Bipolar Transistors
 * Copyright (c) 2007-2012,  Prabhu Desai http://mbed.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "motorlib.h"
#include "mbed.h"

#ifdef LM293D_MOTOR_CTRL
Motor::Motor(PinName r1, PinName r4, MCtrlType mctype):
    _r1(r1), _r4(r4),_mctype(mctype)  {
 
    _r1=0 ;_r4=0;
 
}

void Motor::coast(void)
{
  if((_mctype == L293D_DISCRETE) || (_mctype == L293D_PWM)){
    _r1=1 ;_r4=1;
  }
}

void Motor::forward(void)
{
  if(_mctype == L293D_PWM){
    _r1=0 ;
     for(float p = 0.0f; p < 1.0f; p += 0.1f) {
        _r4 = p;
        wait(0.1);
      }      
  }else if (_mctype == L293D_DISCRETE) {
    _r1=0 ;_r4 = 1;
  }

}
void Motor::backward(void)
{
  if (_mctype == L293D_PWM){
    _r4=0 ;
     for(float p = 0.0f; p < 1.0f; p += 0.1f) {
        _r1 = p;
        wait(0.1);
      }      
  }else if (_mctype == L293D_DISCRETE){
    _r4=0 ;_r1 =1;
  } 
}

void Motor::stop(void)
{
  _r1=1; _r4=1; 
}

#else 
Motor::Motor(PinName r1, PinName r2, PinName r3, PinName r4, MCtrlType mctype):
    _r1(r1), _r2(r2), _r3(r3), _r4(r4),_mctype(mctype)  {
     _r1=1 ; _r2=1  ;_r3=1  ;_r4=1;
}

void Motor::coast(void)
{
  _r1=0 ; _r2=1  ;_r3=0;_r4=1;
}

void Motor::forward(void)
{   
  _r1=0 ; _r2=0  ;_r3=1  ;_r4=1;
 
}

void Motor::backward(void)
{ 
   _r1=1 ; _r2=1  ;_r3=0  ;_r4=0;
}

void Motor::stop(void)
{
  _r1=1 ; _r2=1  ;_r3=1  ;_r4=1;

}
 
#endif
 
/*
//Test code for driving h-Bridge
// Assume there are two motors connected to a chasis 
// a right and a left motor.


Motor  left_motor(LED1,LED2,LED3,LED4);
Motor  right_motor(LED1,LED2,LED3,LED4);

void main(){
  //To drive the robot forward  
  left_motor.forward();
  right_motor.backward();
  
  // To drive the robot backward  
  left_motor.backward();
  right_motor.forward();  
  
  // To turn the robot LEFT 
  left_motor.stop();
  right_motor.forward();    

  // To turn the robot RIGHT  
  left_motor.forward();
  right_motor.stop();    

}

*/