/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef MBED_CLASSES_H
#define MBED_CLASSES_H

#include "rpc.h"
#include "alarmContainer.h"

namespace mbed {

    class RpcDigitalOut : public RPC {
    public:
        RpcDigitalOut(PinName a0, const char *name=NULL) : RPC(name), o(a0) {}
    
        void write(int a0) {o.write(a0);}
        int read(void) {return o.read();}
    
        virtual const struct rpc_method *get_rpc_methods() {
            static const rpc_method rpc_methods[] = {
                {"write", rpc_method_caller<RpcDigitalOut, int, &RpcDigitalOut::write>},
                {"read", rpc_method_caller<int, RpcDigitalOut, &RpcDigitalOut::read>},
                RPC_METHOD_SUPER(RPC)
            };
            return rpc_methods;
        }
        static struct rpc_class *get_rpc_class() {
            static const rpc_function funcs[] = {
                {"new", rpc_function_caller<const char*, PinName, const char*, &RPC::construct<RpcDigitalOut, PinName, const char*> >},
                RPC_METHOD_END
            };
            static rpc_class c = {"DigitalOut", funcs, NULL};
            return &c;
        }
    private:
        DigitalOut o;
    };
    
    class RpcAlarm : public RPC {
        public:
            // Shouldnt need pinName.
            RpcAlarm(const char *name=NULL) : RPC(name) {}
        
            void setAlarm()
            {
                printf("Setting alarm.."); 
                _alarm.setAlarm(); 
                printf("Alarm set.\n");
            }
                    
            void updateAlarmPreference(int hours, int minutes, int amPm){
                printf("Updating alarm preferences..");
                _alarm.updateAlarmPreference(hours,minutes,amPm);
                printf("Preferences set.\n");
            }
        
            virtual const struct rpc_method *get_rpc_methods() {
                static const rpc_method rpc_methods[] = {
                    {"setAlarm", rpc_method_caller<RpcAlarm, &RpcAlarm::setAlarm>},
                    {"updateAlarmPreference", rpc_method_caller<RpcAlarm, int, int, int, &RpcAlarm::updateAlarmPreference>},
                    RPC_METHOD_SUPER(RPC)
                };
                return rpc_methods;
            }
            static struct rpc_class *get_rpc_class() {
                static const rpc_function funcs[] = {
                    {"new", rpc_function_caller<const char*, const char*, &RPC::construct<RpcAlarm, const char*> >},
                    RPC_METHOD_END
                };
                static rpc_class c = {"Alarm", funcs, NULL};
                return &c;
            }
        private:
            //Alarm ();
    };

/*    class RpcAlarm : public RPC {
        public:
            // Shouldnt need pinName.
            RpcAlarm(const char *name=NULL) : RPC(name) {}
        
            void setAlarm(){
                printf("Setting alarm.."); 
                _alarm.setAlarm(); 
                printf("Alarm set.\n");
            }
            
            void updateAlarmPreference(int hours, int minutes, int amPm){
                printf("Updating alarm preferences..");
                _alarm.updateAlarmPreference(hours,minutes,amPm);
                printf("Preferences set.\n");
            }
        
            virtual const struct rpc_method *get_rpc_methods() {
                static const rpc_method rpc_methods[] = {
                    {"setAlarm", rpc_method_caller<RpcAlarm, &RpcAlarm::setAlarm>},
                    {"updateAlarmPreference", rpc_method_caller<RpcAlarm, int, int, int, &RpcAlarm::updateAlarmPreference>},
                    RPC_METHOD_SUPER(RPC)
                };
                return rpc_methods;
            }
            static struct rpc_class *get_rpc_class() {
                static const rpc_function funcs[] = {
                    {"new", rpc_function_caller<const char*, const char*, &RPC::construct<RpcAlarm, const char*> >},
                    RPC_METHOD_END
                };
                static rpc_class c = {"RpcAlarm", funcs, NULL};
                return &c;
            }
        private:
            //RpcAlarm ();
    };*/

}

#endif
