/**
*   Paul Rabbat (prabbat3@gatech.edu) and Himanshu Pandey (hpandey3@gatech.edu)
*   ECE4180 - Georgia Institute of Technology
*   Lab 4
*   October 21, 2014
*/

#include "mbed.h"
#include "WiflyInterface.h"
#include "NTPClient.h"
#include "uLCD_4DGL.h"

/* wifly object where:
*     - p9 and p10 are for the serial communication
*     - p25 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p9, p10, p25, p26, "Los Pollos Hermanos", "", NONE);

//SET UP ULCD
uLCD_4DGL uLCD(p28, p27, p29); // serial tx, serial rx, reset pin;
NTPClient ntpClient;
 
int main() {
    time_t ctTime; //system time structure
    uLCD.baudrate(2000000); //Crank up Baudrate
    uLCD.cls();    //Clear uLCD screen
    uLCD.background_color(BLACK); //SET BACKGROUND COLOR TO WHITE
    //SETS THE BACKGROUND COLOR OF TEXT TO WHITE ON THE ULCD
    uLCD.textbackground_color(BLACK);
    uLCD.locate(0,0);  //Start printing on col0, row0
    uLCD.printf("Getting IP Address\n"); //Print to uLCD
    wifly.init(); //USE DHCP to get local IP address
    wifly.connect(); //Connect to the network
    uLCD.printf("IP ADDRESS is %s\n",wifly.getIPAddress()); //Get Ethernet Address and display It on ULCD
    wait(3.0);
    uLCD.printf("Reading Time...\n");
    char* domainName="us.pool.ntp.org"; //SET TO DOMAIN NAME OF SERVER GETTING TIME FROM
    //GETS THE TIME FROM THE SERVER
    //setTime(DOMAIN_NAME,PORT_NUMBER,TIME_OUT)
    //DOMAIN_NAME= domain name
    //PORT NUMBER=port number (123 for NTP)
    //TIME_OUT= timeout value for request
    ntpClient.setTime(domainName,123,0x00005000);
    uLCD.printf("Time Set\n");
    //Delay for human time to read LCD display
    wait(3.0);
    uLCD.cls();
    //SETS THE BACKGROUND COLOR OF TEXT TO WHITE ON THE ULCD
    uLCD.textbackground_color(BLACK);
    char buffer[80]; //BUFFER TO HOLD FORMATTED TIME DATA
    uLCD.color(RED);
    wifly.disconnect(); //DISCONNECT FROM THE NETWORK 
    uLCD.text_height(2); //2x Text Height
    while (1) {
        // loop and periodically update the LCD's time display
        uLCD.locate(0,0);
        ctTime = time(NULL)-(3600*4);  //TIME with offset for eastern time US
        //FORMAT TIME FOR DISPLAY AND STORE FORMATTED RESULT IN BUFFER
        strftime(buffer,80,"%a %b %d\n%T %p %z\n %Z\n",localtime(&ctTime));
        uLCD.printf("Univ Time Clock\n%s", buffer);
        wait(.1);
    }  
}