#include "mbed.h"

#define LOW 0
#define HIGH 1

PwmOut pwmA(PTC9);
DigitalOut Ain1(PTB1);
DigitalOut Ain2(PTB0);
PwmOut pwmB(PTA1);
DigitalOut Bin1(PTB3);
DigitalOut Bin2(PTC2);
DigitalOut Stby(PTB2);

int main() {
    float p_a = 0.00002f;//50KHz
    float p_b = 0.00002f;
    float pw_a = 1.0;//duty cycle 0.0~1.0 ->  0%~100%
    float pw_b = 1.0;
    
    pwmA.period(p_a);
    pwmB.period(p_b);
    
    pwmA = pw_a;
    pwmB = pw_b;
    
    while(1) {
        //CW
        Stby = HIGH;
        
        Ain1 = HIGH;
        Ain2 = LOW;
        
        Bin1 = HIGH;
        Bin2 = LOW;
        
        wait(5);
        
        //STBY
        Stby = LOW;
        
        wait(5);
        
        //CCW
        Stby = HIGH;
        Ain1 = LOW;
        Ain2 = HIGH;
        
        Bin1 = LOW;
        Bin2 = HIGH;
        
        wait(5);
        
        //STOP
        Ain1 = LOW;
        Ain2 = LOW;
        
        Bin1 = LOW;
        Bin2 = LOW;
        
        wait(5);
        
    }
}
